/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.data.TableCell;
import org.fest.util.Preconditions;

public final class JTableLocation {
    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTable table, int row, int column) {
        Rectangle cellBounds = this.cellBounds(table, row, column);
        return new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        return this.cellBounds(table, cell.row, cell.column);
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(JTable table, int row, int column) {
        return (Rectangle)Preconditions.checkNotNull((Object)table.getCellRect(row, column, false));
    }
}

