/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TextMatcher;

public class JTableHeaderLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Integer, Point> pointAt(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher) {
        int index = this.indexOf(tableHeader, matcher);
        if (this.isValidIndex(tableHeader, index)) {
            return Pair.of(index, JTableHeaderLocation.point(tableHeader, index));
        }
        String format = "Unable to find column with name matching %s %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues());
        throw new LocationUnavailableException(msg);
    }

    @RunsInCurrentThread
    private boolean isValidIndex(@Nonnull JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        return index >= 0 && index < itemCount;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTableHeader tableHeader, int index) {
        return JTableHeaderLocation.point(tableHeader, this.checkIndexInBounds(tableHeader, index));
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point point(@Nonnull JTableHeader tableHeader, int index) {
        Rectangle r = tableHeader.getHeaderRect(index);
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInCurrentThread
    private int checkIndexInBounds(@Nonnull JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        String msg = String.format("Item index <%d> should be between <0> and <%d>", index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    @RunsInCurrentThread
    public int indexOf(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher) {
        int size = this.columnCount(tableHeader);
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(this.columnName(tableHeader, i))) continue;
            return i;
        }
        return -1;
    }

    @RunsInCurrentThread
    private int columnCount(@Nonnull JTableHeader header) {
        return header.getColumnModel().getColumnCount();
    }

    @RunsInCurrentThread
    private String columnName(@Nonnull JTableHeader tableHeader, int index) {
        return tableHeader.getTable().getModel().getColumnName(index);
    }
}

