/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JInternalFrameAction;
import org.fest.swing.driver.JInternalFrameCloseTask;
import org.fest.swing.driver.JInternalFrameIconQuery;
import org.fest.swing.driver.JInternalFrameSetIconTask;
import org.fest.swing.driver.JInternalFrameSetMaximumTask;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JInternalFrameDriver
extends JComponentDriver {
    public JInternalFrameDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveToFront(final @Nonnull JInternalFrame internalFrame) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                internalFrame.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(final @Nonnull JInternalFrame internalFrame) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                internalFrame.moveToBack();
            }
        });
    }

    @RunsInEDT
    public void maximize(@Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> maximizeLocation = JInternalFrameDriver.maximizeLocationOf(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.MAXIMIZE, maximizeLocation);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Container, Point> maximizeLocationOf(final @Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            @Nullable
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkCanMaximize(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private static void checkCanMaximize(@Nonnull JInternalFrame internalFrame) {
        JInternalFrameDriver.checkShowingOrIconified(internalFrame);
        if (!internalFrame.isMaximizable()) {
            String msg = String.format("The JInternalFrame <%s> is not maximizable", Formatting.format(internalFrame));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    public void normalize(@Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> normalizeLocation = JInternalFrameDriver.validateAndFindNormalizeLocation(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.NORMALIZE, normalizeLocation);
    }

    @RunsInEDT
    private static Pair<Container, Point> validateAndFindNormalizeLocation(final @Nonnull JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkShowingOrIconified(@Nonnull JInternalFrame internalFrame) {
        if (!internalFrame.isIcon()) {
            ComponentPreconditions.checkShowing(internalFrame);
        }
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Container, Point> findMaximizeLocation(@Nonnull JInternalFrame internalFrame) {
        JComponent clickTarget = internalFrame.isIcon() ? internalFrame.getDesktopIcon() : internalFrame;
        Point location = WindowLikeContainers.maximizeButtonLocation((Container)Preconditions.checkNotNull((Object)clickTarget));
        return Pair.of(clickTarget, location);
    }

    @RunsInEDT
    private void maximizeOrNormalize(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action, @Nonnull Pair<Container, Point> toMoveMouseTo) {
        this.moveMouseIgnoringAnyError((Component)toMoveMouseTo.first, (Point)toMoveMouseTo.second);
        this.setMaximumProperty(internalFrame, action);
    }

    @RunsInEDT
    private void setMaximumProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action) {
        try {
            JInternalFrameSetMaximumTask.setMaximum(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @RunsInEDT
    public void iconify(@Nonnull JInternalFrame internalFrame) {
        Pair<Boolean, Point> iconifyInfo = JInternalFrameDriver.findIconifyInfo(internalFrame);
        if (((Boolean)iconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, (Point)iconifyInfo.second);
        this.setIconProperty(internalFrame, JInternalFrameAction.ICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> findIconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            @Nullable
            protected Pair<Boolean, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                if (!internalFrame.isIconifiable()) {
                    String msg = String.format("The JInternalFrame <%s> is not iconifiable.", Formatting.format(internalFrame));
                    throw new IllegalStateException(msg);
                }
                return JInternalFrameDriver.iconifyInfo(internalFrame);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Boolean, Point> iconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean iconified = JInternalFrameIconQuery.isIconified(internalFrame);
        if (iconified) {
            return Pair.of(true, null);
        }
        return Pair.of(iconified, JInternalFrameDriver.findIconifyLocation(internalFrame));
    }

    @RunsInEDT
    public void deiconify(@Nonnull JInternalFrame internalFrame) {
        Triple<Boolean, Container, Point> deiconifyInfo = JInternalFrameDriver.validateAndfindDeiconifyInfo(internalFrame);
        if (((Boolean)deiconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError((Component)deiconifyInfo.second, (Point)deiconifyInfo.third);
        this.setIconProperty(internalFrame, JInternalFrameAction.DEICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Container, Point> validateAndfindDeiconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        Triple<Boolean, Container, Point> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Container, Point>>(){

            @Override
            @Nullable
            protected Triple<Boolean, Container, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.deiconifyInfo(internalFrame);
            }
        });
        return (Triple)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Triple<Boolean, Container, Point> deiconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean deiconified;
        boolean bl = deiconified = !JInternalFrameIconQuery.isIconified(internalFrame);
        if (deiconified) {
            return Triple.of(true, null, null);
        }
        Container desktopIcon = (Container)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        return Triple.of(deiconified, desktopIcon, WindowLikeContainers.iconifyButtonLocation(desktopIcon));
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point findIconifyLocation(JInternalFrame internalFrame) {
        JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        return WindowLikeContainers.iconifyButtonLocation(desktopIcon);
    }

    @RunsInEDT
    private void setIconProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action) {
        try {
            JInternalFrameSetIconTask.setIcon(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @VisibleForTesting
    void failIfVetoed(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action, @Nonnull UnexpectedException unexpected) {
        PropertyVetoException vetoError = this.vetoFrom(unexpected);
        if (vetoError == null) {
            return;
        }
        String msg = String.format("%s of %s was vetoed: <%s>", action.name, Formatting.format(internalFrame), vetoError.getMessage());
        throw ActionFailedException.actionFailure(msg);
    }

    @Nullable
    private PropertyVetoException vetoFrom(@Nonnull UnexpectedException unexpected) {
        Throwable cause = unexpected.getCause();
        if (!(cause instanceof PropertyVetoException)) {
            return null;
        }
        return (PropertyVetoException)cause;
    }

    @RunsInEDT
    public void resizeWidth(@Nonnull JInternalFrame internalFrame, int width) {
        this.doResizeWidth(internalFrame, width);
    }

    @RunsInEDT
    public void resizeHeight(@Nonnull JInternalFrame w, int height) {
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull JInternalFrame internalFrame, @Nonnull Dimension size) {
        this.resize(internalFrame, size.width, size.height);
    }

    @RunsInEDT
    public void move(@Nonnull JInternalFrame internalFrame, @Nonnull Point where) {
        this.move(internalFrame, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull JInternalFrame internalFrame) {
        Point closeButtonLocation = JInternalFrameDriver.findCloseButtonLocation(internalFrame);
        if (closeButtonLocation == null) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, closeButtonLocation);
        JInternalFrameCloseTask.close(internalFrame);
        this.robot.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    private static Point findCloseButtonLocation(final @Nonnull JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            @Nullable
            protected Point executeInEDT() {
                ComponentPreconditions.checkShowing(internalFrame);
                if (!internalFrame.isClosable()) {
                    String msg = String.format("The JInternalFrame <%s> is not closable", Formatting.format(internalFrame));
                    throw new IllegalStateException(msg);
                }
                if (internalFrame.isClosed()) {
                    return null;
                }
                return WindowLikeContainers.closeButtonLocation(internalFrame);
            }
        });
    }
}

