/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.Actions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.JComponentToolTipQuery;
import org.fest.swing.driver.KeyStrokes;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JComponentDriver<T extends JComponent>
extends ContainerDriver<T> {
    private static final String TOOL_TIP_TEXT_PROPERTY = "toolTipText";

    public JComponentDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInCurrentThread
    protected final void scrollToVisible(@Nonnull T c, @Nonnull Rectangle r) {
        ((JComponent)c).scrollRectToVisible(r);
    }

    @RunsInCurrentThread
    protected static boolean isVisible(@Nonnull JComponent c, @Nonnull Rectangle r) {
        return c.getVisibleRect().contains(r);
    }

    @RunsInCurrentThread
    protected final boolean isVisible(@Nonnull T c, @Nonnull Point p) {
        return ((JComponent)c).getVisibleRect().contains(p);
    }

    @RunsInEDT
    protected final void invokeAction(@Nonnull JComponent c, @Nonnull String name) {
        this.robot.focusAndWaitForFocusGain(c);
        for (KeyStroke keyStroke : JComponentDriver.keyStrokesForAction(c, name)) {
            try {
                this.type((KeyStroke)Preconditions.checkNotNull((Object)keyStroke));
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw ActionFailedException.actionFailure(String.format("Unable to type any key for the action with key '%s'", name));
    }

    @RunsInCurrentThread
    private static KeyStroke[] keyStrokesForAction(@Nonnull JComponent component, @Nonnull String actionName) {
        Object key = Actions.findActionKey(actionName, (ActionMap)Preconditions.checkNotNull((Object)component.getActionMap()));
        return KeyStrokes.findKeyStrokesForAction(actionName, key, (InputMap)Preconditions.checkNotNull((Object)component.getInputMap()));
    }

    private void type(@Nonnull KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull JComponent c, @Nullable String expected) {
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull T c, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public Object clientProperty(@Nonnull T c, @Nonnull Object key) {
        return JComponentDriver.clientPropertyIn(c, Preconditions.checkNotNull((Object)key));
    }

    @Nullable
    private static Object clientPropertyIn(final @Nonnull JComponent c, final @Nonnull Object key) {
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            @Nullable
            protected Object executeInEDT() {
                return c.getClientProperty(key);
            }
        });
    }
}

