/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Lists;

final class JComboBoxDropDownListFinder {
    static final ComponentMatcher LIST_MATCHER = new TypeMatcher(JList.class);
    private final Robot robot;

    JComboBoxDropDownListFinder(Robot robot) {
        this.robot = robot;
    }

    @Nullable
    @RunsInEDT
    JList findDropDownList() {
        JPopupMenu popup = this.robot.findActivePopupMenu();
        if (popup == null) {
            TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.robot.settings().timeoutToFindPopup());
            popup = this.robot.findActivePopupMenu();
            while (popup == null) {
                if (watch.isTimeOut()) {
                    return null;
                }
                Pause.pause();
                popup = this.robot.findActivePopupMenu();
            }
        }
        return this.findListIn(popup);
    }

    @Nullable
    private JList findListIn(@Nonnull Container parent) {
        ArrayList found = Lists.newArrayList(this.robot.finder().findAll(parent, LIST_MATCHER));
        if (found.size() != 1) {
            return null;
        }
        return (JList)found.get(0);
    }
}

