/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JComboBoxContentQuery {
    @Nonnull
    @RunsInEDT
    static String[] contents(final @Nonnull JComboBox comboBox, final @Nonnull JComboBoxCellReader cellReader) {
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            @Nullable
            protected String[] executeInEDT() {
                int itemCount = comboBox.getItemCount();
                String[] values = new String[itemCount];
                for (int i = 0; i < itemCount; ++i) {
                    values[i] = cellReader.valueAt(comboBox, i);
                }
                return values;
            }
        });
        return (String[])Preconditions.checkNotNull((Object)result);
    }

    private JComboBoxContentQuery() {
    }
}

