/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import javax.annotation.Nonnull;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.swing.util.RobotFactory;
import org.fest.util.Preconditions;

class RobotEventGenerator
implements InputEventGenerator {
    private static final int KEY_INPUT_DELAY = 200;
    private final Robot robot;
    private final Settings settings;

    RobotEventGenerator() {
        this(new Settings());
    }

    RobotEventGenerator(@Nonnull Settings settings) {
        this(new RobotFactory(), settings);
    }

    RobotEventGenerator(@Nonnull RobotFactory robotFactory, @Nonnull Settings settings) {
        try {
            this.robot = robotFactory.newRobotInPrimaryScreen();
            if (Platform.isWindows() || Platform.isOSX()) {
                Pause.pause(500L);
            }
        }
        catch (AWTException e) {
            throw UnexpectedException.unexpected(e);
        }
        this.settings = settings;
        settings.attachTo(this.robot);
    }

    @Nonnull
    Robot robot() {
        return this.robot;
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where, int buttons) {
        Point p = (Point)Preconditions.checkNotNull((Object)AWT.translate(c, where.x, where.y));
        if (!AWT.isPointInScreenBoundaries(p)) {
            throw ActionFailedException.actionFailure("The component to click is out of the boundaries of the screen");
        }
        this.pressMouse(p, buttons);
    }

    @Override
    public void pressMouse(@Nonnull Point where, int buttons) {
        this.moveMouse(where.x, where.y);
        this.pressMouse(buttons);
    }

    @Override
    public void pressMouse(int buttons) {
        this.robot.mousePress(buttons);
    }

    @Override
    public void releaseMouse(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    @Override
    public void rotateMouseWheel(int amount) {
        this.robot.mouseWheel(amount);
    }

    @Override
    public void moveMouse(@Nonnull Component c, int x, int y) {
        Point p = (Point)Preconditions.checkNotNull((Object)AWT.translate(c, x, y));
        this.moveMouse(p.x, p.y);
    }

    @Override
    public void moveMouse(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    @Override
    public void pressKey(int keyCode, char keyChar) {
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid key code '%d'", keyCode));
        }
    }

    @Override
    public void releaseKey(int keyCode) {
        this.robot.keyRelease(keyCode);
        if (!Platform.isOSX()) {
            return;
        }
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (200 > delayBetweenEvents) {
            Pause.pause(200 - delayBetweenEvents);
        }
    }
}

