/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Preconditions;

public abstract class GenericTypeMatcher<T extends Component>
extends AbstractComponentMatcher {
    private final Class<T> supportedType;

    public GenericTypeMatcher(@Nonnull Class<T> supportedType) {
        this(supportedType, false);
    }

    public GenericTypeMatcher(@Nonnull Class<T> supportedType, boolean requireShowing) {
        super(requireShowing);
        this.supportedType = (Class)Preconditions.checkNotNull(supportedType);
    }

    @Override
    @RunsInCurrentThread
    public final boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        if (!this.supportedType.isInstance(c)) {
            return false;
        }
        try {
            return this.requireShowingMatches(c) && this.isMatching((Component)this.supportedType.cast(c));
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    @Nonnull
    public final Class<T> supportedType() {
        return this.supportedType;
    }

    @RunsInCurrentThread
    protected abstract boolean isMatching(@Nonnull T var1);
}

