/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinderStrategy;
import org.fest.swing.core.HierarchyBasedFocusOwnerFinder;
import org.fest.swing.core.ReflectionBasedFocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public final class FocusOwnerFinder {
    private static final List<FocusOwnerFinderStrategy> STRATEGIES = Lists.newArrayList();

    @VisibleForTesting
    static void initializeStrategies() {
        FocusOwnerFinder.replaceStrategiesWith(new ReflectionBasedFocusOwnerFinder(), new HierarchyBasedFocusOwnerFinder());
    }

    @VisibleForTesting
    static void replaceStrategiesWith(FocusOwnerFinderStrategy ... strategies) {
        STRATEGIES.clear();
        STRATEGIES.addAll(Lists.newArrayList((Object[])strategies));
    }

    @Nonnull
    @VisibleForTesting
    static List<FocusOwnerFinderStrategy> strategies() {
        return Lists.newArrayList(STRATEGIES);
    }

    @Nullable
    @RunsInEDT
    public static Component inEdtFocusOwner() {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                return FocusOwnerFinder.focusOwner();
            }
        });
    }

    @Nullable
    @RunsInCurrentThread
    public static Component focusOwner() {
        for (FocusOwnerFinderStrategy strategy : STRATEGIES) {
            Component focusOwner = FocusOwnerFinder.focusOwnerFrom((FocusOwnerFinderStrategy)Preconditions.checkNotNull((Object)strategy));
            if (focusOwner == null) continue;
            return focusOwner;
        }
        return null;
    }

    @Nullable
    private static Component focusOwnerFrom(@Nonnull FocusOwnerFinderStrategy strategy) {
        try {
            return strategy.focusOwner();
        }
        catch (Exception e) {
            return null;
        }
    }

    private FocusOwnerFinder() {
    }

    static {
        FocusOwnerFinder.initializeStrategies();
    }
}

