/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.ui.CollectionListModel;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommitHash;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewCommentState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewCommentModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.ui.SimpleEventListener;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0013\u0010+\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020&H\u0002J\u0010\u00101\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\u0015\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"0!\u00a2\u0006\u0002\b$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModelImpl;", "Lcom/intellij/ui/CollectionListModel;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentModel;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "thread", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "(Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;)V", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommitHash;", "getCommit", "()Lorg/jetbrains/plugins/github/api/data/GHCommitHash;", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "diffHunk", "", "getDiffHunk", "()Ljava/lang/String;", "filePath", "getFilePath", "id", "getId", "<set-?>", "", "isOutdated", "()Z", "isResolved", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewCommentState;", "state", "getState", "()Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewCommentState;", "stateEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addAndInvokeStateChangeListener", "", "listener", "Lkotlin/Function0;", "addComment", "comment", "equals", "other", "", "hashCode", "", "maybeMarkFirstCommentResolved", "update", "intellij.vcs.github"})
public final class GHPRReviewThreadModelImpl
extends CollectionListModel<GHPRReviewCommentModel>
implements GHPRReviewThreadModel {
    @NotNull
    private final String id;
    @NotNull
    private final Date createdAt;
    @NotNull
    private GHPullRequestReviewCommentState state;
    private boolean isResolved;
    private boolean isOutdated;
    @Nullable
    private final GHCommitHash commit;
    @NotNull
    private final String filePath;
    @NotNull
    private final String diffHunk;
    private final EventDispatcher<SimpleEventListener> stateEventDispatcher;

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @NotNull
    public GHPullRequestReviewCommentState getState() {
        return this.state;
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    @Nullable
    public GHCommitHash getCommit() {
        return this.commit;
    }

    @Override
    @NotNull
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public String getDiffHunk() {
        return this.diffHunk;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull GHPullRequestReviewThread thread) {
        Collection<GHPRReviewCommentModel> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GHPullRequestReviewComment newComment;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        boolean dataChanged = false;
        if (this.getState() != thread.getState()) {
            this.state = thread.getState();
            dataChanged = true;
        }
        if (this.isResolved() != thread.isResolved()) {
            this.isResolved = thread.isResolved();
            dataChanged = true;
        }
        if (this.isOutdated() != thread.isOutdated()) {
            this.isOutdated = thread.isOutdated();
            dataChanged = true;
        }
        if (dataChanged) {
            ((SimpleEventListener)this.stateEventDispatcher.getMulticaster()).eventOccurred();
        }
        int removed = 0;
        int n = 0;
        int n2 = this.getItems().size();
        while (n < n2) {
            GHPRReviewCommentModel comment;
            void i2;
            void idx = i2 - removed;
            newComment = (GHPullRequestReviewComment)CollectionsKt.getOrNull(thread.getComments(), (int)idx);
            if (newComment == null) {
                this.removeRange((int)idx, this.getItems().size() - 1);
                break;
            }
            List list2 = this.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"items");
            if ((GHPRReviewCommentModel)CollectionsKt.getOrNull((List)list2, (int)idx) == null) {
                break;
            }
            if (Intrinsics.areEqual((Object)comment.getId(), (Object)newComment.getId())) {
                if (comment.update(newComment)) {
                    this.fireContentsChanged(this, (int)idx, (int)idx);
                }
            } else {
                this.remove((int)idx);
                ++removed;
            }
            ++i2;
        }
        List<GHPullRequestReviewComment> newComments = thread.getComments().subList(this.getSize(), thread.getComments().size());
        Iterable iterable = newComments;
        GHPRReviewThreadModelImpl gHPRReviewThreadModelImpl = this;
        boolean $i$f$map = false;
        newComment = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHPullRequestReviewComment gHPullRequestReviewComment = (GHPullRequestReviewComment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GHPRReviewCommentModel gHPRReviewCommentModel = GHPRReviewCommentModel.Companion.convert((GHPullRequestReviewComment)it);
            collection.add(gHPRReviewCommentModel);
        }
        collection = (List)destination$iv$iv;
        gHPRReviewThreadModelImpl.add((List)collection);
        this.maybeMarkFirstCommentResolved();
    }

    /*
     * WARNING - void declaration
     */
    private final void maybeMarkFirstCommentResolved() {
        if (this.getSize() > 0) {
            ((GHPRReviewCommentModel)this.getElementAt(0)).setFirstInResolvedThread(this.isResolved());
            int n = 1;
            int n2 = this.getSize();
            while (n < n2) {
                void i2;
                ((GHPRReviewCommentModel)this.getElementAt((int)i2)).setFirstInResolvedThread(false);
                ++i2;
            }
        }
    }

    @Override
    public void addComment(@NotNull GHPRReviewCommentModel comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.add(comment);
    }

    @Override
    public void addAndInvokeStateChangeListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        SimpleEventListener.Companion.addAndInvokeListener(this.stateEventDispatcher, listener2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRReviewThreadModelImpl)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.getId(), (Object)((GHPRReviewThreadModelImpl)other).getId()) ^ true);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public GHPRReviewThreadModelImpl(@NotNull GHPullRequestReviewThread thread) {
        Collection<GHPRReviewCommentModel> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Iterable iterable = thread.getComments();
        GHPRReviewCommentModel.Companion companion = GHPRReviewCommentModel.Companion;
        GHPRReviewThreadModelImpl gHPRReviewThreadModelImpl = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            GHPullRequestReviewComment gHPullRequestReviewComment = (GHPullRequestReviewComment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GHPRReviewCommentModel gHPRReviewCommentModel = companion.convert((GHPullRequestReviewComment)p1);
            collection.add(gHPRReviewCommentModel);
        }
        collection = (List)destination$iv$iv;
        super((List)collection);
        this.id = thread.getId();
        this.createdAt = thread.getCreatedAt();
        this.state = thread.getState();
        this.isResolved = thread.isResolved();
        this.isOutdated = thread.isOutdated();
        this.commit = thread.getOriginalCommit();
        this.filePath = thread.getPath();
        this.diffHunk = thread.getDiffHunk();
        EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(S\u2026ventListener::class.java)");
        this.stateEventDispatcher = eventDispatcher;
        this.maybeMarkFirstCommentResolved();
    }
}

