/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

public class ObjectAssert
extends GenericAssert<ObjectAssert, Object> {
    protected ObjectAssert(@Nullable Object actual) {
        super(ObjectAssert.class, actual);
    }

    @Nonnull
    public ObjectAssert isInstanceOf(@Nonnull Class<?> type) {
        this.isNotNull();
        Preconditions.checkNotNull(type);
        Class<?> current = this.actual.getClass();
        if (type.isAssignableFrom(current)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected instance of:<%s> but was instance of:<%s>", type, current));
    }

    @Nonnull
    public ObjectAssert isInstanceOfAny(Class<?> ... types) {
        this.isNotNull();
        Preconditions.checkNotNull(types);
        if (!this.foundInstanceOfAny(types)) {
            String format = "expected instance of any:<%s> but was instance of:<%s>";
            this.fail(String.format(format, this.typeNames(types), this.actual.getClass().getName()));
        }
        return this;
    }

    private boolean foundInstanceOfAny(Class<?> ... types) {
        Class<?> current = this.actual.getClass();
        for (Class<?> type : types) {
            Preconditions.checkNotNull(type);
            if (!type.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private String typeNames(Class<?> ... types) {
        return Arrays.toString(Objects.namesOf((Class[])types));
    }
}

