/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;

public class WorkerLogEventListener
implements OutputEventListener {
    private final AtomicReference<WorkerLoggingProtocol> workerLoggingProtocol = new AtomicReference();

    public void setWorkerLoggingProtocol(WorkerLoggingProtocol workerLoggingProtocol) {
        this.workerLoggingProtocol.getAndSet(workerLoggingProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object withWorkerLoggingProtocol(WorkerLoggingProtocol newLoggingProtocol, Callable<?> callable) throws Exception {
        WorkerLoggingProtocol defaultProtocol = this.workerLoggingProtocol.getAndSet(newLoggingProtocol);
        try {
            Object obj = callable.call();
            return obj;
        }
        finally {
            this.workerLoggingProtocol.getAndSet(defaultProtocol);
        }
    }

    @Override
    public void onOutput(OutputEvent event) {
        WorkerLoggingProtocol loggingProtocol = this.workerLoggingProtocol.get();
        if (loggingProtocol == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " received an output event before the worker logging protocol object was set.");
        }
        if (event instanceof LogEvent) {
            loggingProtocol.sendOutputEvent((LogEvent)event);
        } else if (event instanceof StyledTextOutputEvent) {
            loggingProtocol.sendOutputEvent((StyledTextOutputEvent)event);
        }
    }
}

