/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.plugin.management.PluginResolutionStrategy;
import org.gradle.plugin.management.internal.PluginManagementSpecInternal;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;

public class DefaultPluginManagementSpec
implements PluginManagementSpecInternal {
    private final PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider;
    private final PluginResolutionStrategyInternal pluginResolutionStrategy;
    private final PluginDependenciesSpec pluginDependenciesSpec;

    public DefaultPluginManagementSpec(PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider, PluginResolutionStrategyInternal pluginResolutionStrategy) {
        this.pluginRepositoryHandlerProvider = pluginRepositoryHandlerProvider;
        this.pluginResolutionStrategy = pluginResolutionStrategy;
        this.pluginDependenciesSpec = new PluginDependenciesSpecImpl();
    }

    @Override
    public void repositories(Action<? super RepositoryHandler> repositoriesAction) {
        repositoriesAction.execute(this.getRepositories());
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.pluginRepositoryHandlerProvider.getPluginRepositoryHandler();
    }

    @Override
    public void resolutionStrategy(Action<? super PluginResolutionStrategy> action) {
        action.execute(this.pluginResolutionStrategy);
    }

    @Override
    public PluginResolutionStrategyInternal getResolutionStrategy() {
        return this.pluginResolutionStrategy;
    }

    @Override
    public void plugins(Action<? super PluginDependenciesSpec> action) {
        action.execute(this.pluginDependenciesSpec);
    }

    @Override
    public PluginDependenciesSpec getPlugins() {
        return this.pluginDependenciesSpec;
    }

    private class PluginDependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;

        private PluginDependencySpecImpl(PluginId id) {
            this.id = id;
        }

        @Override
        public PluginDependencySpec version(String version) {
            DefaultPluginManagementSpec.this.pluginResolutionStrategy.setDefaultPluginVersion(this.id, version);
            return this;
        }

        @Override
        public PluginDependencySpec apply(boolean apply) {
            if (apply) {
                throw new IllegalArgumentException("Cannot apply a plugin from within a pluginManagement block.");
            }
            return this;
        }
    }

    private class PluginDependenciesSpecImpl
    implements PluginDependenciesSpec {
        private PluginDependenciesSpecImpl() {
        }

        @Override
        public PluginDependencySpec id(String id) {
            return new PluginDependencySpecImpl(DefaultPluginId.of(id));
        }
    }
}

