/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IvyPluginPublishingPlugin
implements Plugin<Project> {
    private final FeaturePreviews featurePreviews;

    @Inject
    IvyPluginPublishingPlugin(FeaturePreviews featurePreviews) {
        this.featurePreviews = featurePreviews;
    }

    @Override
    public void apply(Project project) {
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                IvyPluginPublishingPlugin.this.configurePublishing(project);
            }
        });
    }

    private void configurePublishing(final Project project) {
        project.getExtensions().configure(PublishingExtension.class, new Action<PublishingExtension>(){

            @Override
            public void execute(PublishingExtension publishing) {
                GradlePluginDevelopmentExtension pluginDevelopment = project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                if (!pluginDevelopment.isAutomatedPublishing()) {
                    return;
                }
                SoftwareComponent mainComponent = (SoftwareComponent)project.getComponents().getByName("java");
                IvyPublication mainPublication = IvyPluginPublishingPlugin.this.addMainPublication(publishing, mainComponent);
                IvyPluginPublishingPlugin.this.addMarkerPublications(mainPublication, publishing, pluginDevelopment);
            }
        });
    }

    private IvyPublication addMainPublication(PublishingExtension publishing, SoftwareComponent mainComponent) {
        IvyPublication publication = publishing.getPublications().maybeCreate("pluginIvy", IvyPublication.class);
        publication.from(mainComponent);
        return publication;
    }

    private void addMarkerPublications(IvyPublication mainPublication, PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        for (PluginDeclaration declaration : pluginDevelopment.getPlugins()) {
            this.createIvyMarkerPublication(declaration, mainPublication, publishing.getPublications());
        }
    }

    private void createIvyMarkerPublication(final PluginDeclaration declaration, final IvyPublication mainPublication, PublicationContainer publications) {
        String pluginId = declaration.getId();
        IvyPublicationInternal publication = (IvyPublicationInternal)publications.create(declaration.getName() + "PluginMarkerIvy", IvyPublication.class);
        publication.setAlias(true);
        publication.setOrganisation(pluginId);
        publication.setModule(pluginId + ".gradle.plugin");
        publication.descriptor((Action<? super IvyModuleDescriptorSpec>)new Action<IvyModuleDescriptorSpec>(){

            @Override
            public void execute(IvyModuleDescriptorSpec descriptor) {
                descriptor.description((Action<? super IvyModuleDescriptorDescription>)new Action<IvyModuleDescriptorDescription>(){

                    @Override
                    public void execute(IvyModuleDescriptorDescription description) {
                        description.getText().set(declaration.getDescription());
                    }
                });
                descriptor.withXml((Action<? super XmlProvider>)new Action<XmlProvider>(){

                    @Override
                    public void execute(XmlProvider xmlProvider) {
                        Element root = xmlProvider.asElement();
                        Document document = root.getOwnerDocument();
                        Node dependencies = root.getElementsByTagName("dependencies").item(0);
                        Node dependency = dependencies.appendChild(document.createElement("dependency"));
                        Attr org = document.createAttribute("org");
                        org.setValue(mainPublication.getOrganisation());
                        dependency.getAttributes().setNamedItem(org);
                        Attr name = document.createAttribute("name");
                        name.setValue(mainPublication.getModule());
                        dependency.getAttributes().setNamedItem(name);
                        Attr rev = document.createAttribute("rev");
                        rev.setValue(mainPublication.getRevision());
                        dependency.getAttributes().setNamedItem(rev);
                    }
                });
            }
        });
    }
}

