/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.VisualCpp;
import org.gradle.nativeplatform.toolchain.VisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.EmptySystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnsupportedPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.DefaultVisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.UcrtInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.UcrtLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualCppToolChain
extends ExtendableToolChain<VisualCppPlatformToolChain>
implements VisualCpp {
    private final String name;
    private final OperatingSystem operatingSystem;
    protected static final Logger LOGGER = LoggerFactory.getLogger(VisualCppToolChain.class);
    public static final String DEFAULT_NAME = "visualCpp";
    private final ExecActionFactory execActionFactory;
    private final VisualStudioLocator visualStudioLocator;
    private final WindowsSdkLocator windowsSdkLocator;
    private final UcrtLocator ucrtLocator;
    private final Instantiator instantiator;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final WorkerLeaseService workerLeaseService;
    private File installDir;
    private File ucrtDir;
    private File windowsSdkDir;
    private UcrtInstall ucrt;
    private VisualStudioInstall visualStudio;
    private VisualCppInstall visualCpp;
    private WindowsSdkInstall windowsSdk;
    private ToolChainAvailability availability;

    public VisualCppToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, VisualStudioLocator visualStudioLocator, WindowsSdkLocator windowsSdkLocator, UcrtLocator ucrtLocator, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        super(name, buildOperationExecutor, operatingSystem, fileResolver);
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.execActionFactory = execActionFactory;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.visualStudioLocator = visualStudioLocator;
        this.windowsSdkLocator = windowsSdkLocator;
        this.ucrtLocator = ucrtLocator;
        this.instantiator = instantiator;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    protected String getTypeName() {
        return "Visual Studio";
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public void setInstallDir(Object installDirPath) {
        this.installDir = this.resolve(installDirPath);
    }

    @Override
    public File getWindowsSdkDir() {
        return this.windowsSdkDir;
    }

    @Override
    public void setWindowsSdkDir(Object windowsSdkDirPath) {
        this.windowsSdkDir = this.resolve(windowsSdkDirPath);
    }

    public File getUcrtDir() {
        return this.ucrtDir;
    }

    public void setUcrtDir(Object ucrtDirPath) {
        this.ucrtDir = this.resolve(ucrtDirPath);
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCpp platformVisualCpp;
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable(this.getAvailability());
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), result);
        }
        org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCpp visualCpp = platformVisualCpp = this.visualCpp == null ? null : this.visualCpp.forPlatform(targetPlatform);
        if (platformVisualCpp == null) {
            return new UnsupportedPlatformToolProvider(targetPlatform.getOperatingSystem(), String.format("Don't know how to build for %s.", targetPlatform.getDisplayName()));
        }
        WindowsSdk platformSdk = this.windowsSdk.forPlatform(targetPlatform);
        SystemLibraries cRuntime = this.ucrt == null ? new EmptySystemLibraries() : this.ucrt.getCRuntime(targetPlatform);
        DefaultVisualCppPlatformToolChain configurableToolChain = this.instantiator.newInstance(DefaultVisualCppPlatformToolChain.class, targetPlatform, this.instantiator);
        this.configureActions.execute(configurableToolChain);
        return new VisualCppPlatformToolProvider(this.buildOperationExecutor, targetPlatform.getOperatingSystem(), configurableToolChain.tools, this.visualStudio, platformVisualCpp, platformSdk, cRuntime, this.execActionFactory, this.compilerOutputFileNamingSchemeFactory, this.workerLeaseService);
    }

    @Override
    public PlatformToolProvider select(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
        switch (sourceLanguage) {
            case CPP: {
                PlatformToolProvider toolProvider = this.select(targetMachine);
                if (!toolProvider.isAvailable()) {
                    return toolProvider;
                }
                CommandLineToolSearchResult cppCompiler = toolProvider.locateTool(ToolType.CPP_COMPILER);
                if (!cppCompiler.isAvailable()) {
                    return new UnavailablePlatformToolProvider(targetMachine.getOperatingSystem(), cppCompiler);
                }
                return toolProvider;
            }
            case ANY: {
                return this.select(targetMachine);
            }
        }
        return new UnsupportedPlatformToolProvider(targetMachine.getOperatingSystem(), String.format("Don't know how to compile language %s.", new Object[]{sourceLanguage}));
    }

    private ToolChainAvailability getAvailability() {
        if (this.availability == null) {
            this.availability = new ToolChainAvailability();
            this.checkAvailable(this.availability);
        }
        return this.availability;
    }

    private void checkAvailable(ToolChainAvailability availability) {
        if (!this.operatingSystem.isWindows()) {
            availability.unavailable("Visual Studio is not available on this operating system.");
            return;
        }
        SearchResult visualStudioSearchResult = this.visualStudioLocator.locateComponent(this.installDir);
        availability.mustBeAvailable(visualStudioSearchResult);
        if (visualStudioSearchResult.isAvailable()) {
            this.visualStudio = (VisualStudioInstall)visualStudioSearchResult.getComponent();
            this.visualCpp = ((VisualStudioInstall)visualStudioSearchResult.getComponent()).getVisualCpp();
        }
        SearchResult windowsSdkSearchResult = this.windowsSdkLocator.locateComponent(this.windowsSdkDir);
        availability.mustBeAvailable(windowsSdkSearchResult);
        if (windowsSdkSearchResult.isAvailable()) {
            this.windowsSdk = (WindowsSdkInstall)windowsSdkSearchResult.getComponent();
        }
        if (this.isVisualCpp2015()) {
            SearchResult ucrtSearchResult = this.ucrtLocator.locateComponent(this.ucrtDir);
            availability.mustBeAvailable(ucrtSearchResult);
            if (ucrtSearchResult.isAvailable()) {
                this.ucrt = (UcrtInstall)ucrtSearchResult.getComponent();
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return "Tool chain '" + this.getName() + "' (" + this.getTypeName() + ")";
    }

    public boolean isVisualCpp2015() {
        return this.visualCpp != null && this.visualCpp.getVersion().getMajor() >= 14;
    }
}

