/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.toolchains;

import javax.inject.Inject;
import org.gradle.internal.Cast;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.util.VersionNumber;

public class DefaultToolChainSelector
implements ToolChainSelector {
    private final ModelRegistry modelRegistry;
    private DefaultNativePlatform host;

    @Inject
    public DefaultToolChainSelector(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.host = DefaultNativePlatform.host();
    }

    @Override
    public <T> ToolChainSelector.Result<T> select(Class<T> platformType, T requestPlatform) {
        if (CppPlatform.class.isAssignableFrom(platformType)) {
            return (ToolChainSelector.Result)Cast.uncheckedCast(this.select((CppPlatform)requestPlatform));
        }
        if (SwiftPlatform.class.isAssignableFrom(platformType)) {
            return (ToolChainSelector.Result)Cast.uncheckedCast(this.select((SwiftPlatform)requestPlatform));
        }
        throw new IllegalArgumentException("Unknown type of platform " + platformType);
    }

    public ToolChainSelector.Result<CppPlatform> select(CppPlatform requestPlatform) {
        DefaultNativePlatform targetNativePlatform = this.newNativePlatform(requestPlatform.getTargetMachine());
        NativeLanguage sourceLanguage = NativeLanguage.CPP;
        NativeToolChainInternal toolChain = this.getToolChain(sourceLanguage, targetNativePlatform);
        PlatformToolProvider toolProvider = toolChain.select(sourceLanguage, targetNativePlatform);
        DefaultCppPlatform targetPlatform = new DefaultCppPlatform(requestPlatform.getTargetMachine(), targetNativePlatform);
        return new DefaultResult<CppPlatform>(toolChain, toolProvider, targetPlatform);
    }

    public ToolChainSelector.Result<SwiftPlatform> select(SwiftPlatform requestPlatform) {
        DefaultNativePlatform targetNativePlatform = this.newNativePlatform(requestPlatform.getTargetMachine());
        NativeLanguage sourceLanguage = NativeLanguage.SWIFT;
        NativeToolChainInternal toolChain = this.getToolChain(sourceLanguage, targetNativePlatform);
        PlatformToolProvider toolProvider = toolChain.select(sourceLanguage, targetNativePlatform);
        SwiftVersion sourceCompatibility = requestPlatform.getSourceCompatibility();
        if (sourceCompatibility == null && toolProvider.isAvailable()) {
            sourceCompatibility = DefaultToolChainSelector.toSwiftVersion(toolProvider.getCompilerMetadata(ToolType.SWIFT_COMPILER).getVersion());
        }
        DefaultSwiftPlatform targetPlatform = new DefaultSwiftPlatform(requestPlatform.getTargetMachine(), sourceCompatibility, targetNativePlatform);
        return new DefaultResult<SwiftPlatform>(toolChain, toolProvider, targetPlatform);
    }

    private DefaultNativePlatform newNativePlatform(TargetMachine targetMachine) {
        return this.host.withArchitecture(Architectures.forInput(targetMachine.getArchitecture().getName()));
    }

    private NativeToolChainInternal getToolChain(NativeLanguage sourceLanguage, NativePlatformInternal targetNativePlatform) {
        NativeToolChainRegistryInternal registry = this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class);
        NativeToolChainInternal toolChain = registry.getForPlatform(sourceLanguage, targetNativePlatform);
        toolChain.assertSupported();
        return toolChain;
    }

    static SwiftVersion toSwiftVersion(VersionNumber swiftCompilerVersion) {
        for (SwiftVersion version : SwiftVersion.values()) {
            if (version.getVersion() != swiftCompilerVersion.getMajor()) continue;
            return version;
        }
        throw new IllegalArgumentException(String.format("Swift language version is unknown for the specified Swift compiler version (%s)", swiftCompilerVersion.toString()));
    }

    static class DefaultResult<T>
    implements ToolChainSelector.Result<T> {
        private final NativeToolChainInternal toolChain;
        private final PlatformToolProvider platformToolProvider;
        private final T targetPlatform;

        DefaultResult(NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, T targetPlatform) {
            this.toolChain = toolChain;
            this.platformToolProvider = platformToolProvider;
            this.targetPlatform = targetPlatform;
        }

        @Override
        public NativeToolChainInternal getToolChain() {
            return this.toolChain;
        }

        @Override
        public T getTargetPlatform() {
            return this.targetPlatform;
        }

        @Override
        public PlatformToolProvider getPlatformToolProvider() {
            return this.platformToolProvider;
        }
    }
}

