/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.EnumMultiset;
import org.gradle.internal.impldep.com.google.common.collect.Multiset;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.vfs.FileSystemWatchingStatistics;

public class DefaultFileSystemWatchingStatistics
implements FileSystemWatchingStatistics {
    private final FileWatcherRegistry.FileWatchingStatistics fileWatchingStatistics;
    private final VirtualFileSystemStatistics vfsStatistics;

    public DefaultFileSystemWatchingStatistics(FileWatcherRegistry.FileWatchingStatistics fileWatchingStatistics, SnapshotHierarchy vfsRoot) {
        this.fileWatchingStatistics = fileWatchingStatistics;
        this.vfsStatistics = DefaultFileSystemWatchingStatistics.getStatistics(vfsRoot);
    }

    @Override
    public int getNumberOfReceivedEvents() {
        return this.fileWatchingStatistics.getNumberOfReceivedEvents();
    }

    @Override
    public int getNumberOfWatchedHierarchies() {
        return this.fileWatchingStatistics.getNumberOfWatchedHierarchies();
    }

    @Override
    public int getRetainedRegularFiles() {
        return this.vfsStatistics.getRetained(FileType.RegularFile);
    }

    @Override
    public int getRetainedDirectories() {
        return this.vfsStatistics.getRetained(FileType.Directory);
    }

    @Override
    public int getRetainedMissingFiles() {
        return this.vfsStatistics.getRetained(FileType.Missing);
    }

    private static VirtualFileSystemStatistics getStatistics(SnapshotHierarchy root) {
        final EnumMultiset retained = EnumMultiset.create(FileType.class);
        root.visitSnapshotRoots(snapshot -> snapshot.accept(new FileSystemSnapshotVisitor(){

            @Override
            public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
                retained.add((Object)directorySnapshot.getType());
                return true;
            }

            @Override
            public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
                retained.add((Object)fileSnapshot.getType());
            }

            @Override
            public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            }
        }));
        return new VirtualFileSystemStatistics((Multiset<FileType>)retained);
    }

    private static class VirtualFileSystemStatistics {
        private final Multiset<FileType> retained;

        public VirtualFileSystemStatistics(Multiset<FileType> retained) {
            this.retained = retained;
        }

        public int getRetained(FileType fileType) {
            return this.retained.count((Object)fileType);
        }
    }
}

