/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.registry.impl.WatchedHierarchies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchicalFileWatcherUpdater.class);
    private final FileWatcher fileWatcher;
    private final FileSystemLocationToWatchValidator locationToWatchValidator;
    private final WatchableHierarchies watchableHierarchies;
    private final WatchedHierarchies watchedHierarchies = new WatchedHierarchies();

    public HierarchicalFileWatcherUpdater(FileWatcher fileWatcher, FileSystemLocationToWatchValidator locationToWatchValidator, Predicate<String> watchFilter) {
        this.fileWatcher = fileWatcher;
        this.locationToWatchValidator = locationToWatchValidator;
        this.watchableHierarchies = new WatchableHierarchies(watchFilter);
    }

    @Override
    public void virtualFileSystemContentsChanged(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        boolean directoriesToWatchChanged = this.watchableHierarchies.getWatchableHierarchies().stream().anyMatch(watchableHierarchy -> {
            boolean hasSnapshotsToWatch = root.hasDescendantsUnder(watchableHierarchy.toString());
            if (this.watchedHierarchies.contains((Path)watchableHierarchy)) {
                return !hasSnapshotsToWatch;
            }
            return hasSnapshotsToWatch;
        });
        if (directoriesToWatchChanged) {
            this.updateWatchedHierarchies(root);
        }
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        this.watchableHierarchies.registerWatchableHierarchy(watchableHierarchy, root);
        this.updateWatchedHierarchies(root);
    }

    @Override
    public SnapshotHierarchy buildFinished(SnapshotHierarchy root, int maximumNumberOfWatchedHierarchies) {
        WatchableHierarchies.Invalidator invalidator = (location, currentRoot) -> currentRoot.invalidate(location, SnapshotHierarchy.NodeDiffListener.NOOP);
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeWatchedHierarchiesOverLimit(root, this.watchedHierarchies::contains, maximumNumberOfWatchedHierarchies, invalidator);
        newRoot = this.watchableHierarchies.removeUnwatchedSnapshots(newRoot, invalidator);
        this.updateWatchedHierarchies(newRoot);
        LOGGER.info("Watched directory hierarchies: {}", this.watchedHierarchies.getWatchedRoots());
        return newRoot;
    }

    @Override
    public int getNumberOfWatchedHierarchies() {
        return this.watchedHierarchies.getWatchedRoots().size();
    }

    private void updateWatchedHierarchies(SnapshotHierarchy root) {
        Set<Path> oldWatchedRoots = this.watchedHierarchies.getWatchedRoots();
        this.watchedHierarchies.updateWatchedHierarchies(this.watchableHierarchies, root);
        Set<Path> newWatchedRoots = this.watchedHierarchies.getWatchedRoots();
        if (newWatchedRoots.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        HashSet<Path> hierarchiesToStopWatching = new HashSet<Path>(oldWatchedRoots);
        HashSet<Path> hierarchiesToStartWatching = new HashSet<Path>(newWatchedRoots);
        hierarchiesToStopWatching.removeAll(newWatchedRoots);
        hierarchiesToStartWatching.removeAll(oldWatchedRoots);
        if (hierarchiesToStartWatching.isEmpty() && hierarchiesToStopWatching.isEmpty()) {
            return;
        }
        if (!hierarchiesToStopWatching.isEmpty()) {
            this.fileWatcher.stopWatching(hierarchiesToStopWatching.stream().map(Path::toFile).collect(Collectors.toList()));
        }
        if (!hierarchiesToStartWatching.isEmpty()) {
            this.fileWatcher.startWatching(hierarchiesToStartWatching.stream().map(Path::toFile).peek(this.locationToWatchValidator::validateLocationToWatch).collect(Collectors.toList()));
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)newWatchedRoots.size());
    }

    public static interface FileSystemLocationToWatchValidator {
        public static final FileSystemLocationToWatchValidator NO_VALIDATION = location -> {};

        public void validateLocationToWatch(File var1);
    }
}

