/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.model.Mutate;
import org.gradle.model.internal.inspect.DefaultRuleSourceValidationProblemCollector;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

public class RuleSourceBackedRuleAction<R, T>
implements RuleAction<T> {
    private final R instance;
    private final JavaMethod<R, T> ruleMethod;
    private final List<Class<?>> inputTypes;

    private RuleSourceBackedRuleAction(R instance, JavaMethod<R, T> ruleMethod) {
        this.instance = instance;
        this.ruleMethod = ruleMethod;
        this.inputTypes = RuleSourceBackedRuleAction.determineInputTypes(ruleMethod.getParameterTypes());
    }

    public static <R, T> RuleSourceBackedRuleAction<R, T> create(ModelType<T> subjectType, R ruleSourceInstance) {
        ModelType<R> ruleSourceType = ModelType.typeOf(ruleSourceInstance);
        List<Method> mutateMethods = RuleSourceBackedRuleAction.findAllMethods(ruleSourceType.getConcreteClass(), element -> element.isAnnotationPresent(Mutate.class));
        FormattingValidationProblemCollector problemsFormatter = new FormattingValidationProblemCollector("rule source", ruleSourceType);
        DefaultRuleSourceValidationProblemCollector problems = new DefaultRuleSourceValidationProblemCollector(problemsFormatter);
        if (mutateMethods.size() == 0) {
            problems.add("Must have at exactly one method annotated with @" + Mutate.class.getName());
        } else {
            if (mutateMethods.size() > 1) {
                problems.add("More than one method is annotated with @" + Mutate.class.getName());
            }
            for (Method ruleMethod : mutateMethods) {
                Type[] parameterTypes;
                if (ruleMethod.getReturnType() != Void.TYPE) {
                    problems.add(ruleMethod, "A rule method must return void");
                }
                if ((parameterTypes = ruleMethod.getGenericParameterTypes()).length != 0 && subjectType.isAssignableFrom(ModelType.of(parameterTypes[0]))) continue;
                problems.add(ruleMethod, String.format("First parameter of a rule method must be of type %s", subjectType));
            }
        }
        if (problemsFormatter.hasProblems()) {
            throw new RuleActionValidationException(problemsFormatter.format());
        }
        return new RuleSourceBackedRuleAction<R, T>(ruleSourceInstance, new JavaMethod(subjectType.getConcreteClass(), mutateMethods.get(0)));
    }

    public static List<Class<?>> determineInputTypes(Class<?>[] parameterTypes) {
        return Arrays.asList(parameterTypes).subList(1, parameterTypes.length);
    }

    @Override
    public List<Class<?>> getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public void execute(T subject, List<?> inputs) {
        Object[] args = new Object[inputs.size() + 1];
        args[0] = subject;
        for (int i = 0; i < inputs.size(); ++i) {
            Object input = inputs.get(i);
            args[i + 1] = input;
        }
        this.ruleMethod.invoke(this.instance, args);
    }

    private static List<Method> findAllMethods(Class<?> target, Spec<Method> predicate) {
        return RuleSourceBackedRuleAction.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(), false);
    }

    private static List<Method> findAllMethodsInternal(Class<?> target, Spec<Method> predicate, MultiMap<String, Method> seen, List<Method> collector, boolean stopAtFirst) {
        for (Method method : target.getDeclaredMethods()) {
            Object seenWithName = seen.get(method.getName());
            Method override = CollectionUtils.findFirst(seenWithName, potentionOverride -> potentionOverride.getName().equals(method.getName()) && Arrays.equals(potentionOverride.getParameterTypes(), method.getParameterTypes()));
            if (override != null) continue;
            seenWithName.add(method);
            if (!predicate.isSatisfiedBy(method)) continue;
            collector.add(method);
            if (!stopAtFirst) continue;
            return collector;
        }
        Class<?> parent = target.getSuperclass();
        if (parent != null) {
            return RuleSourceBackedRuleAction.findAllMethodsInternal(parent, predicate, seen, collector, stopAtFirst);
        }
        return collector;
    }

    private static class MultiMap<K, V>
    extends HashMap<K, List<V>> {
        private MultiMap() {
        }

        @Override
        public List<V> get(Object key) {
            if (!this.containsKey(key)) {
                Object keyCast = key;
                this.put(keyCast, new LinkedList());
            }
            return (List)super.get(key);
        }
    }
}

