/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;

class SerializedOperationStart
implements SerializedOperation {
    final long id;
    final Long parentId;
    final String displayName;
    final long startTime;
    final Object details;
    final String detailsClassName;

    SerializedOperationStart(BuildOperationDescriptor descriptor, OperationStartEvent startEvent) {
        this.id = descriptor.getId().getId();
        this.parentId = descriptor.getParentId() == null ? null : Long.valueOf(descriptor.getParentId().getId());
        this.displayName = descriptor.getDisplayName();
        this.startTime = startEvent.getStartTime();
        this.details = BuildOperationTrace.toSerializableModel(descriptor.getDetails());
        this.detailsClassName = this.details == null ? null : descriptor.getDetails().getClass().getName();
    }

    SerializedOperationStart(Map<String, ?> map2) {
        this.id = ((Integer)map2.get("id")).longValue();
        Integer parentId = (Integer)map2.get("parentId");
        this.parentId = parentId == null ? null : Long.valueOf(parentId.longValue());
        this.displayName = (String)map2.get("displayName");
        this.startTime = (Long)map2.get("startTime");
        this.details = map2.get("details");
        this.detailsClassName = (String)map2.get("detailsClassName");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        map2.put((Object)"displayName", (Object)this.displayName);
        if (this.details != null) {
            map2.put((Object)"details", this.details);
            map2.put((Object)"detailsClassName", (Object)this.detailsClassName);
        }
        map2.put((Object)"id", (Object)this.id);
        if (this.parentId != null) {
            map2.put((Object)"parentId", (Object)this.parentId);
        }
        map2.put((Object)"startTime", (Object)this.startTime);
        return map2.build();
    }
}

