/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import java.lang.reflect.Modifier;
import org.gradle.api.Transformer;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ConstructorSelector;
import org.gradle.internal.instantiation.generator.InjectUtil;
import org.gradle.internal.logging.text.TreeFormatter;

class Jsr330ConstructorSelector
implements ConstructorSelector {
    private final CrossBuildInMemoryCache<Class<?>, CachedConstructor> constructorCache;
    private final ClassGenerator classGenerator;

    public Jsr330ConstructorSelector(ClassGenerator classGenerator, CrossBuildInMemoryCache<Class<?>, CachedConstructor> constructorCache) {
        this.constructorCache = constructorCache;
        this.classGenerator = classGenerator;
    }

    @Override
    public void vetoParameters(ClassGenerator.GeneratedConstructor<?> constructor, Object[] parameters) {
        for (Object param : parameters) {
            if (param != null) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Null value provided in parameters ");
            formatter.appendValues(parameters);
            throw new IllegalArgumentException(formatter.toString());
        }
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forParams(Class<T> type, Object[] params) {
        return this.forType(type);
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forType(final Class<T> type) throws UnsupportedOperationException {
        CachedConstructor constructor = this.constructorCache.get(type, new Transformer<CachedConstructor, Class<?>>(){

            @Override
            public CachedConstructor transform(Class<?> aClass) {
                try {
                    Jsr330ConstructorSelector.validateType(type);
                    ClassGenerator.GeneratedClass implClass = Jsr330ConstructorSelector.this.classGenerator.generate(type);
                    ClassGenerator.GeneratedConstructor constructor = InjectUtil.selectConstructor(implClass, type);
                    return CachedConstructor.of(constructor);
                }
                catch (RuntimeException e) {
                    return CachedConstructor.of(e);
                }
            }
        });
        return (ClassGenerator.GeneratedConstructor)Cast.uncheckedCast(constructor.getConstructor());
    }

    private static <T> void validateType(Class<T> type) {
        if (!type.isInterface() && type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append(" is a non-static inner class.");
            throw new IllegalArgumentException(formatter.toString());
        }
    }

    public static class CachedConstructor {
        private final ClassGenerator.GeneratedConstructor<?> constructor;
        private final RuntimeException error;

        private CachedConstructor(ClassGenerator.GeneratedConstructor<?> constructor, RuntimeException error) {
            this.constructor = constructor;
            this.error = error;
        }

        public ClassGenerator.GeneratedConstructor<?> getConstructor() {
            if (this.error != null) {
                throw this.error;
            }
            return this.constructor;
        }

        public static CachedConstructor of(ClassGenerator.GeneratedConstructor<?> ctor) {
            return new CachedConstructor(ctor, null);
        }

        public static CachedConstructor of(RuntimeException err) {
            return new CachedConstructor(null, err);
        }
    }
}

