/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.file.TreeType;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOutputsStep<C extends Context, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateOutputsStep.class);
    private final Step<? super C, ? extends R> delegate;

    public CreateOutputsStep(Step<? super C, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(C context) {
        context.getWork().visitOutputProperties((name, type, root) -> CreateOutputsStep.ensureOutput(name, root, type));
        return this.delegate.execute(context);
    }

    private static void ensureOutput(String name, File outputRoot, TreeType type) {
        switch (type) {
            case DIRECTORY: {
                LOGGER.debug("Ensuring directory exists for property {} at {}", (Object)name, (Object)outputRoot);
                GFileUtils.mkdirs(outputRoot);
                break;
            }
            case FILE: {
                LOGGER.debug("Ensuring parent directory exists for property {} at {}", (Object)name, (Object)outputRoot);
                GFileUtils.mkdirs(outputRoot.getParentFile());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

