/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.internal.execution.history.changes.AbstractFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FilePathWithType;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;

public class NormalizedPathFingerprintCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new NormalizedPathFingerprintCompareStrategy();

    private NormalizedPathFingerprintCompareStrategy() {
    }

    @Override
    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> currentFingerprints, Map<String, FileSystemLocationFingerprint> previousFingerprints, String propertyTitle) {
        ListMultimap<FileSystemLocationFingerprint, FilePathWithType> unaccountedForPreviousFiles = NormalizedPathFingerprintCompareStrategy.getUnaccountedForPreviousFingerprints(previousFingerprints, currentFingerprints.entrySet());
        ListMultimap<String, FilePathWithType> addedFilesByNormalizedPath = NormalizedPathFingerprintCompareStrategy.getAddedFilesByNormalizedPath(currentFingerprints, unaccountedForPreviousFiles, previousFingerprints.entrySet());
        Iterator iterator = unaccountedForPreviousFiles.entries().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (iterator.hasNext()) {
            FilePathWithType pathWithType;
            Map.Entry entry = (Map.Entry)iterator.next();
            FileSystemLocationFingerprint previousFingerprint = (FileSystemLocationFingerprint)entry.getKey();
            Change change = this.getChange(propertyTitle, addedFilesByNormalizedPath, previousFingerprint, pathWithType = (FilePathWithType)entry.getValue());
            if (visitor.visitChange(change)) continue;
            return false;
        }
        for (Map.Entry entry : addedFilesByNormalizedPath.entries()) {
            Change added = NormalizedPathFingerprintCompareStrategy.added(propertyTitle, entry);
            if (visitor.visitChange(added)) continue;
            return false;
        }
        return true;
    }

    private Change getChange(String propertyTitle, ListMultimap<String, FilePathWithType> addedFilesByNormalizedPath, FileSystemLocationFingerprint previousFingerprint, FilePathWithType pathWithType) {
        String normalizedPath = previousFingerprint.getNormalizedPath();
        FileType previousFingerprintType = previousFingerprint.getType();
        String absolutePath = pathWithType.getAbsolutePath();
        List filePathWithTypes = addedFilesByNormalizedPath.get((Object)normalizedPath);
        Optional<FilePathWithType> match = filePathWithTypes.stream().filter(file -> absolutePath.equals(file.getAbsolutePath())).findFirst();
        return match.map(filePathWithType -> {
            filePathWithTypes.remove(filePathWithType);
            return NormalizedPathFingerprintCompareStrategy.modified(propertyTitle, previousFingerprintType, normalizedPath, filePathWithType);
        }).orElseGet(() -> NormalizedPathFingerprintCompareStrategy.removed(propertyTitle, normalizedPath, pathWithType));
    }

    private static ListMultimap<FileSystemLocationFingerprint, FilePathWithType> getUnaccountedForPreviousFingerprints(Map<String, FileSystemLocationFingerprint> previousFingerprints, Set<Map.Entry<String, FileSystemLocationFingerprint>> currentEntries) {
        ListMultimap results = MultimapBuilder.hashKeys((int)previousFingerprints.size()).linkedListValues().build();
        for (Map.Entry<String, FileSystemLocationFingerprint> previousEntry : previousFingerprints.entrySet()) {
            if (currentEntries.contains(previousEntry)) continue;
            String absolutePath = previousEntry.getKey();
            FileSystemLocationFingerprint previousFingerprint = previousEntry.getValue();
            FileType previousFingerprintType = previousFingerprint.getType();
            results.put((Object)previousFingerprint, (Object)new FilePathWithType(absolutePath, previousFingerprintType));
        }
        return results;
    }

    private static ListMultimap<String, FilePathWithType> getAddedFilesByNormalizedPath(Map<String, FileSystemLocationFingerprint> currentFingerprints, ListMultimap<FileSystemLocationFingerprint, FilePathWithType> unaccountedForPreviousFiles, Set<Map.Entry<String, FileSystemLocationFingerprint>> previousEntries) {
        ListMultimap results = MultimapBuilder.linkedHashKeys().arrayListValues(1).build();
        for (Map.Entry<String, FileSystemLocationFingerprint> currentEntry : currentFingerprints.entrySet()) {
            if (previousEntries.contains(currentEntry)) continue;
            String absolutePath = currentEntry.getKey();
            FileSystemLocationFingerprint currentFingerprint = currentEntry.getValue();
            List previousFilesForFingerprint = unaccountedForPreviousFiles.get((Object)currentFingerprint);
            FileType fingerprintType = currentFingerprint.getType();
            if (previousFilesForFingerprint.isEmpty()) {
                results.put((Object)currentFingerprint.getNormalizedPath(), (Object)new FilePathWithType(absolutePath, fingerprintType));
                continue;
            }
            previousFilesForFingerprint.remove(0);
        }
        return results;
    }

    private static Change modified(String propertyTitle, FileType previousFingerprintType, String normalizedPath, FilePathWithType modifiedFile) {
        String absolutePath = modifiedFile.getAbsolutePath();
        FileType fileType = modifiedFile.getFileType();
        return DefaultFileChange.modified(absolutePath, propertyTitle, previousFingerprintType, fileType, normalizedPath);
    }

    private static Change removed(String propertyTitle, String normalizedPath, FilePathWithType removedFile) {
        String absolutePath = removedFile.getAbsolutePath();
        FileType fileType = removedFile.getFileType();
        return DefaultFileChange.removed(absolutePath, propertyTitle, fileType, normalizedPath);
    }

    private static Change added(String propertyTitle, Map.Entry<String, FilePathWithType> addedFilesByNormalizedPathEntries) {
        FilePathWithType addedFile = addedFilesByNormalizedPathEntries.getValue();
        String absolutePath = addedFile.getAbsolutePath();
        FileType fileType = addedFile.getFileType();
        String normalizedPath = addedFilesByNormalizedPathEntries.getKey();
        return DefaultFileChange.added(absolutePath, propertyTitle, fileType, normalizedPath);
    }
}

