/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AdditionalVariant;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.LazyRuleAwareWithBaseConfigurationMetadata;
import org.gradle.internal.component.external.model.LazyVariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public abstract class AbstractLazyModuleComponentResolveMetadata
extends AbstractModuleComponentResolveMetadata {
    private final VariantMetadataRules variantMetadataRules;
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private Optional<ImmutableList<? extends ConfigurationMetadata>> graphVariants;
    private final Map<String, ConfigurationMetadata> configurations = Maps.newHashMap();

    protected AbstractLazyModuleComponentResolveMetadata(AbstractMutableModuleComponentResolveMetadata metadata) {
        super(metadata);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.variantMetadataRules = metadata.getVariantMetadataRules();
    }

    protected AbstractLazyModuleComponentResolveMetadata(AbstractLazyModuleComponentResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy variantDerivationStrategy) {
        super(metadata, sources, variantDerivationStrategy);
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.variantMetadataRules = metadata.variantMetadataRules;
    }

    protected void copyCachedState(AbstractLazyModuleComponentResolveMetadata metadata, boolean copyGraphVariants) {
        metadata.copyCachedConfigurations(this.configurations);
        if (copyGraphVariants) {
            this.graphVariants = metadata.graphVariants;
        }
    }

    private synchronized void copyCachedConfigurations(Map<String, ConfigurationMetadata> target) {
        target.putAll(this.configurations);
    }

    @Override
    public VariantMetadataRules getVariantMetadataRules() {
        return this.variantMetadataRules;
    }

    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    private Optional<ImmutableList<? extends ConfigurationMetadata>> buildVariantsForGraphTraversal() {
        ImmutableList variants = this.getVariants();
        if (variants.isEmpty()) {
            return this.addVariantsByRule(this.maybeDeriveVariants());
        }
        ImmutableList.Builder configurations = new ImmutableList.Builder();
        for (ComponentVariant variant : variants) {
            configurations.add((Object)new LazyVariantBackedConfigurationMetadata(this.getId(), variant, this.getAttributes(), this.getAttributesFactory(), this.variantMetadataRules));
        }
        return this.addVariantsByRule((Optional<ImmutableList<? extends ConfigurationMetadata>>)Optional.of((Object)configurations.build()));
    }

    private Optional<ImmutableList<? extends ConfigurationMetadata>> addVariantsByRule(Optional<ImmutableList<? extends ConfigurationMetadata>> variants) {
        if (this.variantMetadataRules.getAdditionalVariants().isEmpty()) {
            return variants;
        }
        Map variantsByName = ((ImmutableList)variants.or((Object)ImmutableList.of())).stream().collect(Collectors.toMap(ConfigurationMetadata::getName, Function.identity()));
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (variants.isPresent()) {
            builder.addAll((Iterable)variants.get());
        }
        for (AdditionalVariant additionalVariant : this.variantMetadataRules.getAdditionalVariants()) {
            String baseName = additionalVariant.getBase();
            ConfigurationMetadata base = null;
            if (baseName != null) {
                if (variants.isPresent()) {
                    base = (ConfigurationMetadata)variantsByName.get(baseName);
                    if (!additionalVariant.isLenient() && !(base instanceof ModuleConfigurationMetadata)) {
                        throw new InvalidUserDataException("Variant '" + baseName + "' not defined in module " + this.getId().getDisplayName());
                    }
                } else {
                    base = this.getConfiguration(baseName);
                    if (!additionalVariant.isLenient() && !(base instanceof ModuleConfigurationMetadata)) {
                        throw new InvalidUserDataException("Configuration '" + baseName + "' not defined in module " + this.getId().getDisplayName());
                    }
                }
            }
            if (baseName != null && !(base instanceof ModuleConfigurationMetadata)) continue;
            LazyRuleAwareWithBaseConfigurationMetadata configurationMetadata = new LazyRuleAwareWithBaseConfigurationMetadata(additionalVariant.getName(), (ModuleConfigurationMetadata)base, this.getId(), this.getAttributes(), this.variantMetadataRules, this.constructVariantExcludes(base));
            builder.add((Object)configurationMetadata);
        }
        return Optional.of((Object)builder.build());
    }

    @Override
    public synchronized Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.graphVariants == null) {
            this.graphVariants = this.buildVariantsForGraphTraversal();
        }
        return this.graphVariants;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurationDefinitions.keySet();
    }

    @Override
    public synchronized ConfigurationMetadata getConfiguration(String name) {
        ConfigurationMetadata populated = this.configurations.get(name);
        if (populated != null) {
            return populated;
        }
        ConfigurationMetadata md = this.populateConfigurationFromDescriptor(name, (Map<String, Configuration>)this.configurationDefinitions);
        this.configurations.put(name, md);
        return md;
    }

    protected ConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions) {
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        if (descriptorConfiguration == null) {
            return null;
        }
        ImmutableSet<String> hierarchy = this.constructHierarchy(descriptorConfiguration);
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        return this.createConfiguration(this.getId(), name, transitive, visible, hierarchy, this.variantMetadataRules);
    }

    private ImmutableSet<String> constructHierarchy(Configuration descriptorConfiguration) {
        if (descriptorConfiguration.getExtendsFrom().isEmpty()) {
            return ImmutableSet.of((Object)descriptorConfiguration.getName());
        }
        ImmutableSet.Builder accumulator = new ImmutableSet.Builder();
        this.populateHierarchy(descriptorConfiguration, (ImmutableSet.Builder<String>)accumulator);
        return accumulator.build();
    }

    private void populateHierarchy(Configuration metadata, ImmutableSet.Builder<String> accumulator) {
        accumulator.add((Object)metadata.getName());
        for (String parentName : metadata.getExtendsFrom()) {
            Configuration parent = (Configuration)this.configurationDefinitions.get((Object)parentName);
            this.populateHierarchy(parent, accumulator);
        }
    }

    private ImmutableList<ExcludeMetadata> constructVariantExcludes(ConfigurationMetadata base) {
        if (base == null) {
            return ImmutableList.of();
        }
        return base.getExcludes();
    }

    protected abstract DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier var1, String var2, boolean var3, boolean var4, ImmutableSet<String> var5, VariantMetadataRules var6);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractLazyModuleComponentResolveMetadata that = (AbstractLazyModuleComponentResolveMetadata)o;
        return Objects.equal(this.configurationDefinitions, that.configurationDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.configurationDefinitions});
    }
}

