/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory {
    private final Instantiator instantiator;
    private final WorkerLeaseService workerLeaseService;

    public DefaultIncludedBuildFactory(Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        this.instantiator = instantiator;
        this.workerLeaseService = workerLeaseService;
    }

    private void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    @Override
    public IncludedBuildState createBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner) {
        this.validateBuildDirectory(buildDefinition.getBuildRootDir());
        return this.instantiator.newInstance(DefaultIncludedBuild.class, buildIdentifier, identityPath, buildDefinition, isImplicit, owner, this.workerLeaseService.getCurrentWorkerLease());
    }
}

