/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class CachingBlockStore
implements BlockStore {
    private final BlockStore store;
    private final Map<BlockPointer, BlockPayload> dirty = new LinkedHashMap<BlockPointer, BlockPayload>();
    private final Cache<BlockPointer, BlockPayload> indexBlockCache = CacheBuilder.newBuilder().maximumSize(100L).concurrencyLevel(1).build();
    private final ImmutableSet<Class<? extends BlockPayload>> cacheableBlockTypes;

    public CachingBlockStore(BlockStore store, Collection<Class<? extends BlockPayload>> cacheableBlockTypes) {
        this.store = store;
        this.cacheableBlockTypes = ImmutableSet.copyOf(cacheableBlockTypes);
    }

    @Override
    public void open(Runnable initAction, BlockStore.Factory factory) {
        this.store.open(initAction, factory);
    }

    @Override
    public void close() {
        this.flush();
        this.indexBlockCache.invalidateAll();
        this.store.close();
    }

    @Override
    public void clear() {
        this.dirty.clear();
        this.indexBlockCache.invalidateAll();
        this.store.clear();
    }

    @Override
    public void flush() {
        Iterator<BlockPayload> iterator = this.dirty.values().iterator();
        while (iterator.hasNext()) {
            BlockPayload block = iterator.next();
            iterator.remove();
            this.store.write(block);
        }
        this.store.flush();
    }

    @Override
    public void attach(BlockPayload block) {
        this.store.attach(block);
    }

    @Override
    public void remove(BlockPayload block) {
        this.dirty.remove(block.getPos());
        if (this.isCacheable(block)) {
            this.indexBlockCache.invalidate((Object)block.getPos());
        }
        this.store.remove(block);
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        T block = this.store.readFirst(payloadType);
        this.maybeCache(block);
        return block;
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        BlockPayload block = (BlockPayload)payloadType.cast(this.dirty.get(pos));
        if (block != null) {
            return (T)block;
        }
        block = this.maybeGetFromCache(pos, payloadType);
        if (block != null) {
            return (T)block;
        }
        block = this.store.read(pos, payloadType);
        this.maybeCache(block);
        return (T)block;
    }

    @Nullable
    private <T extends BlockPayload> T maybeGetFromCache(BlockPointer pos, Class<T> payloadType) {
        if (this.cacheableBlockTypes.contains(payloadType)) {
            return (T)((BlockPayload)payloadType.cast(this.indexBlockCache.getIfPresent((Object)pos)));
        }
        return null;
    }

    @Override
    public void write(BlockPayload block) {
        this.store.attach(block);
        this.maybeCache(block);
        this.dirty.put(block.getPos(), block);
    }

    private <T extends BlockPayload> void maybeCache(T block) {
        if (this.isCacheable(block)) {
            this.indexBlockCache.put((Object)block.getPos(), block);
        }
    }

    private <T extends BlockPayload> boolean isCacheable(T block) {
        return this.cacheableBlockTypes.contains(block.getClass());
    }
}

