/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;

public abstract class AbstractOptions
implements Serializable {
    private static final long serialVersionUID = 0L;

    public void define(@Nullable Map<String, Object> args) {
        if (args == null) {
            return;
        }
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            this.setProperty(arg.getKey(), arg.getValue());
        }
    }

    public Map<String, Object> optionMap() {
        final HashMap map2 = Maps.newHashMap();
        for (Class<?> currClass = new DslObject(this).getDeclaredType(); currClass != AbstractOptions.class; currClass = currClass.getSuperclass()) {
            for (final Field field : currClass.getDeclaredFields()) {
                if (!this.isOptionField(field)) continue;
                DeprecationLogger.whileDisabled(new Runnable(){

                    @Override
                    public void run() {
                        AbstractOptions.this.addValueToMapIfNotNull(map2, field);
                    }
                });
            }
        }
        return map2;
    }

    protected boolean excludeFromAntProperties(String fieldName) {
        return false;
    }

    protected String getAntPropertyName(String fieldName) {
        return fieldName;
    }

    protected Object getAntPropertyValue(String fieldName, Object value) {
        return value;
    }

    private void setProperty(String property, Object value) {
        JavaPropertyReflectionUtil.writeableProperty(this.getClass(), property, value == null ? null : value.getClass()).setValue(this, value);
    }

    private void addValueToMapIfNotNull(Map<String, Object> map2, Field field) {
        Object value = JavaPropertyReflectionUtil.readableProperty(this, Object.class, field.getName()).getValue(this);
        if (value != null) {
            map2.put(this.getAntPropertyName(field.getName()), this.getAntPropertyValue(field.getName(), value));
        }
    }

    private boolean isOptionField(Field field) {
        return (field.getModifiers() & 8) == 0 && !field.getName().equals("metaClass") && !field.getName().equals("fileResolver") && !this.excludeFromAntProperties(field.getName());
    }
}

