/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.specs.Spec;

public class JavaConfigurationVariantMapping
implements Action<ConfigurationVariantDetails> {
    private final String scope;
    private final boolean optional;

    public JavaConfigurationVariantMapping(String scope, boolean optional) {
        this.scope = scope;
        this.optional = optional;
    }

    @Override
    public void execute(ConfigurationVariantDetails details) {
        ConfigurationVariant variant = details.getConfigurationVariant();
        if (UnpublishableArtifactTypeSpec.INSTANCE.isSatisfiedBy(variant)) {
            details.skip();
        } else {
            details.mapToMavenScope(this.scope);
            if (this.optional) {
                details.mapToOptional();
            }
        }
    }

    private static class UnpublishableArtifactTypeSpec
    implements Spec<ConfigurationVariant> {
        private static final UnpublishableArtifactTypeSpec INSTANCE = new UnpublishableArtifactTypeSpec();

        private UnpublishableArtifactTypeSpec() {
        }

        @Override
        public boolean isSatisfiedBy(ConfigurationVariant element) {
            for (PublishArtifact artifact : element.getArtifacts()) {
                if (!JavaBasePlugin.UNPUBLISHABLE_VARIANT_ARTIFACTS.contains(artifact.getType())) continue;
                return true;
            }
            return false;
        }
    }
}

