/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.components.ComponentReport;
import org.gradle.api.reporting.dependents.DependentComponentsReport;
import org.gradle.api.reporting.model.ModelReport;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.diagnostics.BuildEnvironmentReportTask;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.OutgoingVariantsReportTask;
import org.gradle.api.tasks.diagnostics.ProjectReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.configuration.Help;

public class HelpTasksPlugin
implements Plugin<Project> {
    public static final String HELP_GROUP = "help";
    public static final String PROPERTIES_TASK = "properties";
    public static final String DEPENDENCIES_TASK = "dependencies";
    public static final String DEPENDENCY_INSIGHT_TASK = "dependencyInsight";
    public static final String COMPONENTS_TASK = "components";
    @Incubating
    public static final String OUTGOING_VARIANTS_TASK = "outgoingVariants";
    public static final String MODEL_TASK = "model";
    public static final String DEPENDENT_COMPONENTS_TASK = "dependentComponents";

    @Override
    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        String projectName = project.toString();
        tasks.register(HELP_GROUP, Help.class, (Action)new HelpAction());
        tasks.register("projects", ProjectReportTask.class, (Action)new ProjectReportTaskAction(projectName));
        tasks.register("tasks", TaskReportTask.class, (Action)new TaskReportTaskAction(projectName, project.getChildProjects().isEmpty()));
        tasks.register(PROPERTIES_TASK, PropertyReportTask.class, (Action)new PropertyReportTaskAction(projectName));
        tasks.register(DEPENDENCY_INSIGHT_TASK, DependencyInsightReportTask.class, (Action)new DependencyInsightReportTaskAction(projectName));
        tasks.register(DEPENDENCIES_TASK, DependencyReportTask.class, (Action)new DependencyReportTaskAction(projectName));
        tasks.register("buildEnvironment", BuildEnvironmentReportTask.class, (Action)new BuildEnvironmentReportTaskAction(projectName));
        tasks.register(COMPONENTS_TASK, ComponentReport.class, (Action)new ComponentReportAction(projectName));
        tasks.register(MODEL_TASK, ModelReport.class, (Action)new ModelReportAction(projectName));
        tasks.register(DEPENDENT_COMPONENTS_TASK, DependentComponentsReport.class, (Action)new DependentComponentsReportAction(projectName));
        tasks.register(OUTGOING_VARIANTS_TASK, OutgoingVariantsReportTask.class, task -> {
            task.setDescription("Displays the outgoing variants of " + projectName + ".");
            task.setGroup(HELP_GROUP);
            task.setImpliesSubProjects(true);
        });
    }

    private static class DependentComponentsReportAction
    implements Action<DependentComponentsReport> {
        private final String projectName;

        public DependentComponentsReportAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(DependentComponentsReport task) {
            task.setDescription("Displays the dependent components of components in " + this.projectName + ". [incubating]");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class ModelReportAction
    implements Action<ModelReport> {
        private final String projectName;

        public ModelReportAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(ModelReport task) {
            task.setDescription("Displays the configuration model of " + this.projectName + ". [incubating]");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class ComponentReportAction
    implements Action<ComponentReport> {
        private final String projectName;

        public ComponentReportAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(ComponentReport task) {
            task.setDescription("Displays the components produced by " + this.projectName + ". [incubating]");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class BuildEnvironmentReportTaskAction
    implements Action<BuildEnvironmentReportTask> {
        private final String projectName;

        public BuildEnvironmentReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(BuildEnvironmentReportTask task) {
            task.setDescription("Displays all buildscript dependencies declared in " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class DependencyReportTaskAction
    implements Action<DependencyReportTask> {
        private final String projectName;

        public DependencyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(DependencyReportTask task) {
            task.setDescription("Displays all dependencies declared in " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class DependencyInsightReportTaskAction
    implements Action<DependencyInsightReportTask> {
        private final String projectName;

        public DependencyInsightReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(DependencyInsightReportTask task) {
            task.setDescription("Displays the insight into a specific dependency in " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
            new DslObject(task).getConventionMapping().map("configuration", () -> {
                BuildableJavaComponent javaProject = ((ProjectInternal)task.getProject()).getServices().get(ComponentRegistry.class).getMainComponent();
                return javaProject == null ? null : javaProject.getCompileDependencies();
            });
        }
    }

    private static class PropertyReportTaskAction
    implements Action<PropertyReportTask> {
        private final String projectName;

        public PropertyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public void execute(PropertyReportTask task) {
            task.setDescription("Displays the properties of " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class TaskReportTaskAction
    implements Action<TaskReportTask> {
        private final String projectName;
        private final boolean noChildren;

        public TaskReportTaskAction(String projectName, boolean noChildren) {
            this.projectName = projectName;
            this.noChildren = noChildren;
        }

        @Override
        public void execute(TaskReportTask task) {
            String description = this.noChildren ? "Displays the tasks runnable from " + this.projectName + "." : "Displays the tasks runnable from " + this.projectName + " (some of the displayed tasks may belong to subprojects).";
            task.setDescription(description);
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class ProjectReportTaskAction
    implements Action<ProjectReportTask> {
        private final String project;

        public ProjectReportTaskAction(String projectName) {
            this.project = projectName;
        }

        @Override
        public void execute(ProjectReportTask task) {
            task.setDescription("Displays the sub-projects of " + this.project + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    private static class HelpAction
    implements Action<Help> {
        private HelpAction() {
        }

        @Override
        public void execute(Help task) {
            task.setDescription("Displays a help message.");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }
}

