/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class DependentsSet {
    public static DependentsSet dependentClasses(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses) {
        return DependentsSet.dependents(privateDependentClasses, accessibleDependentClasses, Collections.emptySet());
    }

    public static DependentsSet dependents(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses, Set<GeneratedResource> dependentResources) {
        if (privateDependentClasses.isEmpty() && accessibleDependentClasses.isEmpty() && dependentResources.isEmpty()) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf(privateDependentClasses), (Set)ImmutableSet.copyOf(accessibleDependentClasses), (Set)ImmutableSet.copyOf(dependentResources));
    }

    public static DependentsSet dependencyToAll() {
        return DependencyToAll.INSTANCE;
    }

    public static DependentsSet dependencyToAll(String reason) {
        return new DependencyToAll(reason);
    }

    public static DependentsSet empty() {
        return EmptyDependentsSet.INSTANCE;
    }

    public abstract boolean isEmpty();

    public abstract boolean hasDependentClasses();

    public abstract Set<String> getPrivateDependentClasses();

    public abstract Set<String> getAccessibleDependentClasses();

    public abstract Set<GeneratedResource> getDependentResources();

    public abstract boolean isDependencyToAll();

    @Nullable
    public abstract String getDescription();

    private DependentsSet() {
    }

    public abstract Set<String> getAllDependentClasses();

    private static class DependencyToAll
    extends DependentsSet {
        private static final DependencyToAll INSTANCE = new DependencyToAll();
        private final String reason;

        private DependencyToAll(String reason) {
            this.reason = reason;
        }

        private DependencyToAll() {
            this((String)null);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public boolean hasDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getAllDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent resources information.");
        }

        @Override
        public boolean isDependencyToAll() {
            return true;
        }

        @Override
        public String getDescription() {
            return this.reason;
        }
    }

    private static class DefaultDependentsSet
    extends DependentsSet {
        private final Set<String> privateDependentClasses;
        private final Set<String> accessibleDependentClasses;
        private final Set<GeneratedResource> dependentResources;

        private DefaultDependentsSet(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses, Set<GeneratedResource> dependentResources) {
            this.privateDependentClasses = privateDependentClasses;
            this.accessibleDependentClasses = accessibleDependentClasses;
            this.dependentResources = dependentResources;
        }

        @Override
        public boolean isEmpty() {
            return !this.hasDependentClasses() && this.dependentResources.isEmpty();
        }

        @Override
        public boolean hasDependentClasses() {
            return !this.privateDependentClasses.isEmpty() || !this.accessibleDependentClasses.isEmpty();
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            return this.privateDependentClasses;
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            return this.accessibleDependentClasses;
        }

        @Override
        public Set<String> getAllDependentClasses() {
            if (this.privateDependentClasses.isEmpty()) {
                return this.accessibleDependentClasses;
            }
            if (this.accessibleDependentClasses.isEmpty()) {
                return this.privateDependentClasses;
            }
            HashSet r = Sets.newHashSet(this.accessibleDependentClasses);
            r.addAll(this.privateDependentClasses);
            return r;
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return this.dependentResources;
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class EmptyDependentsSet
    extends DependentsSet {
        private static final EmptyDependentsSet INSTANCE = new EmptyDependentsSet();

        private EmptyDependentsSet() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean hasDependentClasses() {
            return false;
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getAllDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return Collections.emptySet();
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }
    }
}

