/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.util.ConfigureUtil;

public class DefaultScalaSourceSet
implements ScalaSourceSet,
HasPublicType {
    private final SourceDirectorySet scala;
    private final SourceDirectorySet allScala;

    public DefaultScalaSourceSet(String displayName, ObjectFactory objectFactory) {
        this.scala = objectFactory.sourceDirectorySet("scala", displayName + " Scala source");
        this.scala.getFilter().include("**/*.java", "**/*.scala");
        this.allScala = objectFactory.sourceDirectorySet("allscala", displayName + " Scala source");
        this.allScala.getFilter().include("**/*.scala");
        this.allScala.source(this.scala);
    }

    @Override
    public SourceDirectorySet getScala() {
        return this.scala;
    }

    @Override
    public ScalaSourceSet scala(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getScala());
        return this;
    }

    @Override
    public ScalaSourceSet scala(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute(this.getScala());
        return this;
    }

    @Override
    public SourceDirectorySet getAllScala() {
        return this.allScala;
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(ScalaSourceSet.class);
    }
}

