/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ModuleComponentFileArtifactIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.resource.cached.AbstractCachedIndex;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultModuleArtifactCache
extends AbstractCachedIndex<ArtifactAtRepositoryKey, CachedArtifact>
implements ModuleArtifactCache {
    private static final ArtifactAtRepositoryKeySerializer KEY_SERIALIZER = DefaultModuleArtifactCache.keySerializer();
    private final BuildCommencedTimeProvider timeProvider;

    public DefaultModuleArtifactCache(String persistentCacheFile, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager, FileAccessTracker fileAccessTracker2, Path commonRootPath) {
        super(persistentCacheFile, KEY_SERIALIZER, new CachedArtifactSerializer(commonRootPath), artifactCacheLockingManager, fileAccessTracker2);
        this.timeProvider = timeProvider;
    }

    protected static ArtifactAtRepositoryKeySerializer keySerializer() {
        DefaultSerializerRegistry serializerRegistry = new DefaultSerializerRegistry();
        serializerRegistry.register(DefaultModuleComponentArtifactIdentifier.class, new ComponentArtifactIdentifierSerializer());
        serializerRegistry.register(ModuleComponentFileArtifactIdentifier.class, new ModuleComponentFileArtifactIdentifierSerializer());
        return new ArtifactAtRepositoryKeySerializer(serializerRegistry.build(ComponentArtifactIdentifier.class));
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, HashCode moduleDescriptorHash) {
        this.assertArtifactFileNotNull(artifactFile);
        this.assertKeyNotNull(key);
        this.storeInternal(key, this.createEntry(artifactFile, moduleDescriptorHash));
    }

    private DefaultCachedArtifact createEntry(File artifactFile, HashCode moduleDescriptorHash) {
        return new DefaultCachedArtifact(artifactFile, this.timeProvider.getCurrentTime(), moduleDescriptorHash);
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, List<String> attemptedLocations, HashCode descriptorHash) {
        this.storeInternal(key, this.createMissingEntry(attemptedLocations, descriptorHash));
    }

    private CachedArtifact createMissingEntry(List<String> attemptedLocations, HashCode descriptorHash) {
        return new DefaultCachedArtifact(attemptedLocations, this.timeProvider.getCurrentTime(), descriptorHash);
    }

    @Override
    public CachedArtifact lookup(ArtifactAtRepositoryKey key) {
        this.assertKeyNotNull(key);
        return (CachedArtifact)super.lookup(key);
    }

    @VisibleForTesting
    static class CachedArtifactSerializer
    implements Serializer<CachedArtifact> {
        private final Path commonRootPath;

        public CachedArtifactSerializer(Path commonRootPath) {
            this.commonRootPath = commonRootPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedArtifactSerializer that = (CachedArtifactSerializer)o;
            return this.commonRootPath.equals(that.commonRootPath);
        }

        public int hashCode() {
            return this.commonRootPath.hashCode();
        }

        @Override
        public void write(Encoder encoder, CachedArtifact value) throws Exception {
            encoder.writeBoolean(value.isMissing());
            encoder.writeLong(value.getCachedAt());
            byte[] hash = value.getDescriptorHash().toByteArray();
            encoder.writeBinary(hash);
            if (!value.isMissing()) {
                encoder.writeString(this.relativizeAndNormalizeFilePath(value.getCachedFile()));
            } else {
                encoder.writeSmallInt(value.attemptedLocations().size());
                for (String location : value.attemptedLocations()) {
                    encoder.writeString(location);
                }
            }
        }

        @Override
        public CachedArtifact read(Decoder decoder) throws Exception {
            boolean isMissing = decoder.readBoolean();
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            HashCode hash = HashCode.fromBytes(encodedHash);
            if (!isMissing) {
                return new DefaultCachedArtifact(this.denormalizeAndResolveFilePath(decoder.readString()), createTimestamp, hash);
            }
            int size = decoder.readSmallInt();
            ArrayList<String> attempted = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                attempted.add(decoder.readString());
            }
            return new DefaultCachedArtifact(attempted, createTimestamp, hash);
        }

        private String relativizeAndNormalizeFilePath(File cachedFile) {
            Path filePath = cachedFile.toPath();
            assert (filePath.startsWith(this.commonRootPath)) : "Attempting to cache file " + filePath + " not in " + this.commonRootPath;
            String systemDependentPath = this.commonRootPath.relativize(filePath).toString();
            if (!filePath.getFileSystem().getSeparator().equals("/")) {
                return systemDependentPath.replace(filePath.getFileSystem().getSeparator(), "/");
            }
            return systemDependentPath;
        }

        private File denormalizeAndResolveFilePath(String relativePath) throws IOException {
            if (!this.commonRootPath.getFileSystem().getSeparator().equals("/")) {
                relativePath = relativePath.replace("/", this.commonRootPath.getFileSystem().getSeparator());
            }
            return this.commonRootPath.resolve(relativePath).toFile();
        }
    }

    private static class ArtifactAtRepositoryKeySerializer
    implements Serializer<ArtifactAtRepositoryKey> {
        private final Serializer<ComponentArtifactIdentifier> artifactIdSerializer;

        public ArtifactAtRepositoryKeySerializer(Serializer<ComponentArtifactIdentifier> artifactIdSerializer) {
            this.artifactIdSerializer = artifactIdSerializer;
        }

        @Override
        public void write(Encoder encoder, ArtifactAtRepositoryKey value) throws Exception {
            encoder.writeString(value.getRepositoryId());
            this.artifactIdSerializer.write(encoder, value.getArtifactId());
        }

        @Override
        public ArtifactAtRepositoryKey read(Decoder decoder) throws Exception {
            String repositoryId = decoder.readString();
            ComponentArtifactIdentifier artifactIdentifier = this.artifactIdSerializer.read(decoder);
            return new ArtifactAtRepositoryKey(repositoryId, artifactIdentifier);
        }
    }
}

