/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.internal.artifacts.dsl.ActionBasedMetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.ClassBasedMetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.MetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.SpecConfigurableRule;
import org.gradle.internal.component.external.model.NoOpDerivationStrategy;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.rules.SpecRuleAction;

class ComponentMetadataRuleContainer
implements Iterable<MetadataRuleWrapper> {
    private final List<MetadataRuleWrapper> rules = Lists.newArrayListWithExpectedSize((int)10);
    private MetadataRuleWrapper lastAdded;
    private boolean classBasedRulesOnly = true;
    private VariantDerivationStrategy variantDerivationStrategy = NoOpDerivationStrategy.getInstance();
    private int rulesHash = 0;

    ComponentMetadataRuleContainer() {
    }

    void addRule(SpecRuleAction<? super ComponentMetadataDetails> ruleAction) {
        this.lastAdded = new ActionBasedMetadataRuleWrapper(ruleAction);
        this.rules.add(this.lastAdded);
        this.classBasedRulesOnly = false;
        this.rulesHash = 31 * this.rulesHash + ruleAction.hashCode();
    }

    void addClassRule(SpecConfigurableRule ruleAction) {
        if (this.lastAdded != null && this.lastAdded.isClassBased()) {
            this.lastAdded.addClassRule(ruleAction);
        } else {
            this.lastAdded = new ClassBasedMetadataRuleWrapper(ruleAction);
            this.rules.add(this.lastAdded);
        }
        this.rulesHash = 31 * this.rulesHash + ruleAction.getConfigurableRule().hashCode();
    }

    boolean isClassBasedRulesOnly() {
        return this.classBasedRulesOnly;
    }

    boolean isEmpty() {
        return this.rules.isEmpty();
    }

    @Override
    public Iterator<MetadataRuleWrapper> iterator() {
        return this.rules.iterator();
    }

    Collection<SpecConfigurableRule> getOnlyClassRules() {
        if (!this.isClassBasedRulesOnly() || this.isEmpty()) {
            throw new IllegalStateException("This method cannot be used unless there is at least one rule and they are all class based");
        }
        return this.rules.get(0).getClassRules();
    }

    public VariantDerivationStrategy getVariantDerivationStrategy() {
        return this.variantDerivationStrategy;
    }

    public void setVariantDerivationStrategy(VariantDerivationStrategy variantDerivationStrategy) {
        this.variantDerivationStrategy = variantDerivationStrategy;
    }

    public int getRulesHash() {
        return 31 * this.variantDerivationStrategy.hashCode() + this.rulesHash;
    }
}

