/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Describables;

public class DefaultPublishArtifactSet
extends DelegatingDomainObjectSet<PublishArtifact>
implements PublishArtifactSet {
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final FileCollection files;
    private final Describable displayName;

    public DefaultPublishArtifactSet(String displayName, DomainObjectSet<PublishArtifact> backingSet, FileCollectionFactory fileCollectionFactory) {
        this(Describables.of(displayName), backingSet, fileCollectionFactory);
    }

    public DefaultPublishArtifactSet(Describable displayName, DomainObjectSet<PublishArtifact> backingSet, FileCollectionFactory fileCollectionFactory) {
        super(backingSet);
        this.displayName = displayName;
        this.files = fileCollectionFactory.create(this.builtBy, new ArtifactsFileCollection());
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public FileCollection getFiles() {
        return this.files;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.builtBy;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            for (PublishArtifact publishArtifact : DefaultPublishArtifactSet.this) {
                context.add(publishArtifact);
            }
        }
    }

    private class ArtifactsFileCollection
    implements MinimalFileSet {
        private ArtifactsFileCollection() {
        }

        @Override
        public String getDisplayName() {
            return DefaultPublishArtifactSet.this.displayName.getDisplayName();
        }

        @Override
        public Set<File> getFiles() {
            LinkedHashSet<File> files2 = new LinkedHashSet<File>();
            for (PublishArtifact artifact : DefaultPublishArtifactSet.this) {
                files2.add(artifact.getFile());
            }
            return files2;
        }
    }
}

