/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.distribution.plugins;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.internal.DefaultDistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.TextUtil;

public class DistributionPlugin
implements Plugin<Project> {
    public static final String MAIN_DISTRIBUTION_NAME = "main";
    public static final String TASK_INSTALL_NAME = "installDist";
    private static final String DISTRIBUTION_GROUP = "distribution";
    private static final String TASK_DIST_ZIP_NAME = "distZip";
    private static final String TASK_DIST_TAR_NAME = "distTar";
    private static final String TASK_ASSEMBLE_NAME = "assembleDist";
    private final Instantiator instantiator;
    private final FileOperations fileOperations;
    private final CollectionCallbackActionDecorator callbackActionDecorator;

    @Inject
    public DistributionPlugin(Instantiator instantiator, FileOperations fileOperations, CollectionCallbackActionDecorator callbackActionDecorator) {
        this.instantiator = instantiator;
        this.fileOperations = fileOperations;
        this.callbackActionDecorator = callbackActionDecorator;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        DistributionContainer distributions = project.getExtensions().create(DistributionContainer.class, "distributions", DefaultDistributionContainer.class, Distribution.class, this.instantiator, project.getObjects(), this.fileOperations, this.callbackActionDecorator);
        distributions.all(dist -> {
            String assembleTaskName;
            String installTaskName;
            String tarTaskName;
            String zipTaskName;
            dist.getContents().from("src/" + dist.getName() + "/dist");
            if (dist.getName().equals(MAIN_DISTRIBUTION_NAME)) {
                zipTaskName = TASK_DIST_ZIP_NAME;
                tarTaskName = TASK_DIST_TAR_NAME;
                installTaskName = TASK_INSTALL_NAME;
                assembleTaskName = TASK_ASSEMBLE_NAME;
                dist.getDistributionBaseName().convention(project.getName());
            } else {
                zipTaskName = dist.getName() + "DistZip";
                tarTaskName = dist.getName() + "DistTar";
                installTaskName = "install" + StringUtils.capitalize((String)dist.getName()) + "Dist";
                assembleTaskName = "assemble" + StringUtils.capitalize((String)dist.getName()) + "Dist";
                dist.getDistributionBaseName().convention(String.format("%s-%s", project.getName(), dist.getName()));
            }
            this.addArchiveTask(project, zipTaskName, (Class)Zip.class, (Distribution)dist);
            this.addArchiveTask(project, tarTaskName, (Class)Tar.class, (Distribution)dist);
            this.addInstallTask(project, installTaskName, (Distribution)dist);
            this.addAssembleTask(project, assembleTaskName, (Distribution)dist, zipTaskName, tarTaskName);
        });
        distributions.create(MAIN_DISTRIBUTION_NAME);
        project.afterEvaluate(p -> distributions.forEach(distribution -> {
            if (((String)distribution.getDistributionBaseName().get()).equals("")) {
                throw new GradleException(String.format("Distribution '%s' must not have an empty distributionBaseName.", distribution.getName()));
            }
        }));
    }

    private <T extends AbstractArchiveTask> void addArchiveTask(Project project, String taskName, Class<T> type, Distribution distribution) {
        NamedDomainObjectProvider archiveTask = project.getTasks().register(taskName, (Class)type, task -> {
            task.setDescription("Bundles the project as a distribution.");
            task.setGroup(DISTRIBUTION_GROUP);
            task.getArchiveBaseName().convention(distribution.getDistributionBaseName());
            CopySpec childSpec = project.copySpec();
            childSpec.with(distribution.getContents());
            childSpec.into(() -> TextUtil.minus((String)task.getArchiveFileName().get(), "." + (String)task.getArchiveExtension().get()));
            task.with(childSpec);
        });
        LazyPublishArtifact archiveArtifact = new LazyPublishArtifact(archiveTask);
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(archiveArtifact);
    }

    private void addInstallTask(Project project, String taskName, Distribution distribution) {
        project.getTasks().register(taskName, Sync.class, installTask -> {
            installTask.setDescription("Installs the project as a distribution as-is.");
            installTask.setGroup(DISTRIBUTION_GROUP);
            installTask.with(distribution.getContents());
            installTask.into(project.getLayout().getBuildDirectory().dir(distribution.getDistributionBaseName().map(baseName -> "install/" + baseName)));
        });
    }

    private void addAssembleTask(Project project, String taskName, Distribution distribution, String ... tasks) {
        project.getTasks().register(taskName, DefaultTask.class, assembleTask -> {
            assembleTask.setDescription("Assembles the " + distribution.getName() + " distributions");
            assembleTask.setGroup(DISTRIBUTION_GROUP);
            assembleTask.dependsOn(tasks);
        });
    }
}

