/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class FastSparseSetFactory<E> {
    private final VBStyleCollection<int[], E> colValuesInternal = new VBStyleCollection();
    private int lastBlock;
    private int lastMask;

    public FastSparseSetFactory(Collection<? extends E> set) {
        int block = -1;
        int mask = -1;
        int index = 0;
        for (E element : set) {
            block = index / 32;
            mask = index % 32 == 0 ? 1 : (mask <<= 1);
            this.colValuesInternal.putWithKey(new int[]{block, mask}, (int[])element);
            ++index;
        }
        this.lastBlock = block;
        this.lastMask = mask;
    }

    private int[] addElement(E element) {
        this.lastMask = this.lastMask == -1 || this.lastMask == Integer.MIN_VALUE ? 1 : (this.lastMask <<= 1);
        int[] pointer = new int[]{++this.lastBlock, this.lastMask};
        this.colValuesInternal.putWithKey(pointer, (int[])element);
        return pointer;
    }

    public FastSparseSet<E> spawnEmptySet() {
        return new FastSparseSet(this);
    }

    public int getLastBlock() {
        return this.lastBlock;
    }

    private VBStyleCollection<int[], E> getInternalValuesCollection() {
        return this.colValuesInternal;
    }

    public static final class FastSparseSetIterator<E>
    implements Iterator<E> {
        private final VBStyleCollection<int[], E> colValuesInternal;
        private final int[] data;
        private final int[] next;
        private final int size;
        private int pointer = -1;
        private int next_pointer = -1;

        private FastSparseSetIterator(FastSparseSet<E> set) {
            this.colValuesInternal = set.getFactory().getInternalValuesCollection();
            this.data = set.getData();
            this.next = set.getNext();
            this.size = this.colValuesInternal.size();
        }

        private int getNextIndex(int index) {
            int bindex = ++index >>> 5;
            int dindex = index & 0x1F;
            while (bindex < this.data.length) {
                int block = this.data[bindex];
                if (block != 0) {
                    block >>>= dindex;
                    while (dindex < 32) {
                        if ((block & 1) != 0) {
                            return (bindex << 5) + dindex;
                        }
                        block >>>= 1;
                        ++dindex;
                    }
                }
                dindex = 0;
                if ((bindex = this.next[bindex]) != 0) continue;
                break;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            this.next_pointer = this.getNextIndex(this.pointer);
            return this.next_pointer >= 0;
        }

        @Override
        public E next() {
            if (this.next_pointer >= 0) {
                this.pointer = this.next_pointer;
            } else {
                this.pointer = this.getNextIndex(this.pointer);
                if (this.pointer == -1) {
                    this.pointer = this.size;
                }
            }
            this.next_pointer = -1;
            return this.pointer < this.size ? (E)this.colValuesInternal.getKey(this.pointer) : null;
        }

        @Override
        public void remove() {
            int[] index = (int[])this.colValuesInternal.get(this.pointer);
            int n = index[0];
            this.data[n] = this.data[n] & ~index[1];
        }
    }

    public static final class FastSparseSet<E>
    implements Iterable<E> {
        public static final FastSparseSet[] EMPTY_ARRAY = new FastSparseSet[0];
        private final FastSparseSetFactory<E> factory;
        private final VBStyleCollection<int[], E> colValuesInternal;
        private int[] data;
        private int[] next;

        private FastSparseSet(FastSparseSetFactory<E> factory) {
            this.factory = factory;
            this.colValuesInternal = factory.getInternalValuesCollection();
            int length = factory.getLastBlock() + 1;
            this.data = new int[length];
            this.next = new int[length];
        }

        private FastSparseSet(FastSparseSetFactory<E> factory, int[] data, int[] next) {
            this.factory = factory;
            this.colValuesInternal = factory.getInternalValuesCollection();
            this.data = data;
            this.next = next;
        }

        public FastSparseSet<E> getCopy() {
            int arrlength = this.data.length;
            int[] cpdata = new int[arrlength];
            int[] cpnext = new int[arrlength];
            System.arraycopy(this.data, 0, cpdata, 0, arrlength);
            System.arraycopy(this.next, 0, cpnext, 0, arrlength);
            return new FastSparseSet<E>(this.factory, cpdata, cpnext);
        }

        private int[] ensureCapacity(int index) {
            int newlength = this.data.length;
            if (newlength == 0) {
                newlength = 1;
            }
            while (newlength <= index) {
                newlength *= 2;
            }
            int[] newdata = new int[newlength];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
            int[] newnext = new int[newlength];
            System.arraycopy(this.next, 0, newnext, 0, this.next.length);
            this.next = newnext;
            return newdata;
        }

        public void add(E element) {
            int block;
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = this.factory.addElement(element);
            }
            if ((block = index[0]) >= this.data.length) {
                this.ensureCapacity(block);
            }
            int n = block;
            this.data[n] = this.data[n] | index[1];
            FastSparseSet.changeNext(this.next, block, this.next[block], block);
        }

        public void remove(E element) {
            int block;
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = this.factory.addElement(element);
            }
            if ((block = index[0]) < this.data.length) {
                int n = block;
                this.data[n] = this.data[n] & ~index[1];
                if (this.data[block] == 0) {
                    FastSparseSet.changeNext(this.next, block, block, this.next[block]);
                }
            }
        }

        public boolean contains(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = this.factory.addElement(element);
            }
            return index[0] < this.data.length && (this.data[index[0]] & index[1]) != 0;
        }

        private void setNext() {
            int link = 0;
            for (int i = this.data.length - 1; i >= 0; --i) {
                this.next[i] = link;
                if (this.data[i] == 0) continue;
                link = i;
            }
        }

        private static void changeNext(int[] arrnext, int key, int oldnext, int newnext) {
            for (int i = key - 1; i >= 0 && arrnext[i] == oldnext; --i) {
                arrnext[i] = newnext;
            }
        }

        public void union(FastSparseSet<E> set) {
            int[] extdata = set.getData();
            int[] extnext = set.getNext();
            int[] intdata = this.data;
            int intlength = intdata.length;
            int pointer = 0;
            do {
                if (pointer >= intlength) {
                    intdata = this.ensureCapacity(extdata.length - 1);
                }
                boolean nextrec = intdata[pointer] == 0;
                int n = pointer;
                intdata[n] = intdata[n] | extdata[pointer];
                if (!nextrec) continue;
                FastSparseSet.changeNext(this.next, pointer, this.next[pointer], pointer);
            } while ((pointer = extnext[pointer]) != 0);
        }

        public void intersection(FastSparseSet<E> set) {
            int i;
            int[] extdata = set.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & extdata[i];
            }
            for (i = intdata.length - 1; i >= minlength; --i) {
                intdata[i] = 0;
            }
            this.setNext();
        }

        public void complement(FastSparseSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            int extlength = extdata.length;
            int pointer = 0;
            while (pointer < extlength) {
                int n = pointer;
                intdata[n] = intdata[n] & ~extdata[pointer];
                if (intdata[pointer] == 0) {
                    FastSparseSet.changeNext(this.next, pointer, pointer, this.next[pointer]);
                }
                if ((pointer = this.next[pointer]) != 0) continue;
            }
        }

        public boolean equals(Object o) {
            int i;
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastSparseSet)) {
                return false;
            }
            int[] longdata = ((FastSparseSet)o).getData();
            int[] shortdata = this.data;
            if (this.data.length > longdata.length) {
                shortdata = longdata;
                longdata = this.data;
            }
            for (i = shortdata.length - 1; i >= 0; --i) {
                if (shortdata[i] == longdata[i]) continue;
                return false;
            }
            for (i = longdata.length - 1; i >= shortdata.length; --i) {
                if (longdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        public int getCardinality() {
            boolean found = false;
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int block = intdata[i];
                if (block == 0) continue;
                if (found) {
                    return 2;
                }
                if ((block & block - 1) == 0) {
                    found = true;
                    continue;
                }
                return 2;
            }
            return found ? 1 : 0;
        }

        public boolean isEmpty() {
            return this.data.length == 0 || this.next[0] == 0 && this.data[0] == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new FastSparseSetIterator(this);
        }

        public Set<E> toPlainSet() {
            HashSet<E> set = new HashSet<E>();
            int[] intdata = this.data;
            int size = this.data.length * 32;
            if (size > this.colValuesInternal.size()) {
                size = this.colValuesInternal.size();
            }
            for (int i = size - 1; i >= 0; --i) {
                int[] index = (int[])this.colValuesInternal.get(i);
                if ((intdata[index[0]] & index[1]) == 0) continue;
                set.add(this.colValuesInternal.getKey(i));
            }
            return set;
        }

        public String toString() {
            return this.toPlainSet().toString();
        }

        private int[] getData() {
            return this.data;
        }

        private int[] getNext() {
            return this.next;
        }

        public FastSparseSetFactory<E> getFactory() {
            return this.factory;
        }
    }
}

