/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import org.jetbrains.annotations.Nullable;

public class FixTypeArguments {
    @Nullable
    public static PsiExpression addTypeArguments(PsiExpression expression, PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
            return null;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            PsiReferenceParameterList list = methodCall.getMethodExpression().getParameterList();
            if (list == null || list.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0) {
                    PsiType[] mappings = PsiType.createArray((int)typeParameters.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression);
                    for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                        PsiType substitution;
                        PsiTypeParameter typeParameter = typeParameters[i2];
                        if (toType == null) {
                            substitution = resolveResult.getSubstitutor().substitute(typeParameter);
                            if (!PsiTypesUtil.isDenotableType((PsiType)substitution, (PsiElement)element)) {
                                return null;
                            }
                        } else {
                            substitution = helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        }
                        if (substitution == null || PsiType.NULL.equals((Object)substitution)) {
                            return null;
                        }
                        mappings[i2] = GenericsUtil.eliminateWildcards((PsiType)substitution, (boolean)false);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    for (PsiType mapping : mappings) {
                        parameterList.add((PsiElement)factory.createTypeElement(mapping));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        Object qualifierExpression = method.hasModifierProperty("static") ? factory.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression((PsiManager)method.getManager(), null);
                        methodExpression.setQualifierExpression((PsiExpression)qualifierExpression);
                    }
                    return copy;
                }
            }
        }
        return null;
    }
}

