/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.classFilter.ClassFilterEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;

class CoverageClassFilterEditor
extends ClassFilterEditor {
    CoverageClassFilterEditor(Project project) {
        super(project, new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return aClass.getContainingClass() == null;
            }
        }, null);
        this.myTable.setVisibleRowCount(4);
    }

    protected void addPatternFilter() {
        List packages;
        PackageChooserDialog chooser = new PackageChooserDialog(JavaCoverageBundle.message("coverage.pattern.filter.editor.choose.package.title", new Object[0]), this.myProject);
        if (chooser.showAndGet() && !(packages = chooser.getSelectedPackages()).isEmpty()) {
            for (PsiPackage aPackage : packages) {
                String fqName = aPackage.getQualifiedName();
                Object pattern = fqName.length() > 0 ? fqName + ".*" : "*";
                this.myTableModel.addRow(this.createFilter((String)pattern));
            }
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    protected String getAddPatternButtonText() {
        return JavaCoverageBundle.message("coverage.button.add.package", new Object[0]);
    }

    protected Icon getAddPatternButtonIcon() {
        return AllIcons.ToolbarDecorator.AddFolder;
    }
}

