/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.tooling.util.DependencyResolver;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;
import org.jetbrains.plugins.gradle.tooling.util.JavaPluginUtil;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.ArtifactQueryResolver;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.CompileDependenciesProvider;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.ExternalDepsResolutionResult;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.MyModuleIdentifier;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.RuntimeDependenciesProvider;

@Deprecated
public class DeprecatedDependencyResolver
implements DependencyResolver {
    private static final boolean is4OrBetter = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.0")) >= 0;
    static final boolean isJavaLibraryPluginSupported = is4OrBetter || GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    static final boolean is31OrBetter = isJavaLibraryPluginSupported || GradleVersion.current().compareTo(GradleVersion.version((String)"3.1")) >= 0;
    private static final boolean isDependencySubstitutionsSupported = is31OrBetter || GradleVersion.current().compareTo(GradleVersion.version((String)"2.5")) > 0;
    private static final boolean isArtifactResolutionQuerySupported = isDependencySubstitutionsSupported || GradleVersion.current().compareTo(GradleVersion.version((String)"2.0")) >= 0;
    @NotNull
    private final Project myProject;
    private final boolean myIsPreview;
    private final boolean myDownloadJavadoc;
    private final boolean myDownloadSources;
    @NotNull
    private final SourceSetCachedFinder mySourceSetFinder;

    public DeprecatedDependencyResolver(@NotNull Project project, boolean isPreview, boolean downloadJavadoc, boolean downloadSources, @NotNull SourceSetCachedFinder sourceSetFinder) {
        if (project == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(0);
        }
        if (sourceSetFinder == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myIsPreview = isPreview;
        this.myDownloadJavadoc = downloadJavadoc;
        this.myDownloadSources = downloadSources;
        this.mySourceSetFinder = sourceSetFinder;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable String configurationName) {
        return this.resolveDependencies(configurationName, null);
    }

    public Collection<ExternalDependency> resolveDependencies(@Nullable String configurationName, @Nullable String scope) {
        if (configurationName == null) {
            return Collections.emptyList();
        }
        return this.resolveDependencies((Configuration)this.myProject.getConfigurations().findByName(configurationName), scope).getExternalDeps();
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration) {
        return this.resolveDependencies(configuration, null).getExternalDeps();
    }

    public ExternalDepsResolutionResult resolveDependencies(@Nullable Configuration configuration, @Nullable String scope) {
        if (configuration == null || configuration.getAllDependencies().isEmpty()) {
            return ExternalDepsResolutionResult.EMPTY;
        }
        ExternalDepsResolutionResult result = !this.myIsPreview && isArtifactResolutionQuerySupported ? new ArtifactQueryResolver(configuration, scope, this.myProject, this.myDownloadJavadoc, this.myDownloadSources, this.mySourceSetFinder).resolve() : new ExternalDepsResolutionResult(this.findDependencies(configuration, (Collection<Dependency>)configuration.getAllDependencies(), scope), new ArrayList<File>());
        Set<ExternalDependency> fileDependencies = DeprecatedDependencyResolver.findAllFileDependencies((Collection<Dependency>)configuration.getAllDependencies(), scope);
        result.getExternalDeps().addAll(fileDependencies);
        return result;
    }

    protected static Multimap<ModuleComponentIdentifier, ProjectDependency> collectProjectDeps(@NotNull Configuration configuration) {
        if (configuration == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(2);
        }
        return DeprecatedDependencyResolver.projectDeps(configuration, (Multimap<ModuleComponentIdentifier, ProjectDependency>)ArrayListMultimap.create(), new HashSet<Configuration>());
    }

    private static Multimap<ModuleComponentIdentifier, ProjectDependency> projectDeps(Configuration conf, Multimap<ModuleComponentIdentifier, ProjectDependency> map, Set<Configuration> processedConfigurations) {
        if (!processedConfigurations.add(conf)) {
            return map;
        }
        for (Dependency dep : conf.getIncoming().getDependencies()) {
            Configuration targetConfiguration;
            if (!(dep instanceof ProjectDependency) || (targetConfiguration = DeprecatedDependencyResolver.getTargetConfiguration((ProjectDependency)dep)) == null) continue;
            map.put((Object)DependencyResolverImpl.toComponentIdentifier(dep.getGroup(), dep.getName(), dep.getVersion()), (Object)((ProjectDependency)dep));
            DeprecatedDependencyResolver.projectDeps(targetConfiguration, map, processedConfigurations);
        }
        return map;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@NotNull SourceSet sourceSet) {
        if (sourceSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(3);
        }
        ArrayList result = new ArrayList();
        CompileDependenciesProvider compileDependenciesProvider = new CompileDependenciesProvider(sourceSet, this.myProject).resolve(this);
        Collection<ExternalDependency> compileDependencies = compileDependenciesProvider.getDependencies();
        RuntimeDependenciesProvider runtimeDependenciesProvider = new RuntimeDependenciesProvider(sourceSet, this.myProject).resolve(this);
        Collection<ExternalDependency> runtimeDependencies = runtimeDependenciesProvider.getDependencies();
        Multimap<Object, ExternalDependency> filesToDependenciesMap = this.collectCompileDependencies(compileDependenciesProvider, runtimeDependenciesProvider);
        this.filterCompileDepsFromRuntime(runtimeDependencies, filesToDependenciesMap);
        result.addAll(compileDependencies);
        result.addAll(runtimeDependencies);
        result = Lists.newArrayList((Iterable)Iterables.filter(result, (Predicate)Predicates.not((Predicate)Predicates.isNull())));
        Set<File> compileClasspathFiles = this.getCompileClasspathFiles(sourceSet, "Java", "Groovy", "Scala");
        Map<File, Integer> compileClasspathOrder = this.addIterationOrder(compileClasspathFiles);
        Set<File> runtimeClasspathFiles = this.getRuntimeClasspathFiles(sourceSet);
        Map<File, Integer> runtimeClasspathOrder = this.addIterationOrder(runtimeClasspathFiles);
        runtimeClasspathFiles.removeAll(compileClasspathFiles);
        runtimeClasspathFiles.removeAll(sourceSet.getOutput().getFiles());
        compileClasspathFiles.removeAll(sourceSet.getOutput().getFiles());
        ArrayListMultimap resolvedDependenciesMap = ArrayListMultimap.create();
        resolvedDependenciesMap.putAll((Object)"COMPILE", compileDependenciesProvider.getFiles());
        resolvedDependenciesMap.putAll((Object)"RUNTIME", runtimeDependenciesProvider.getFiles());
        Project rootProject = this.myProject.getRootProject();
        for (ExternalDependency dependency : new DependencyTraverser(result)) {
            ExternalProjectDependency projectDependency;
            Project project;
            SourceSet mainSourceSet;
            this.updateDependencyOrder(compileClasspathOrder, runtimeClasspathOrder, dependency);
            resolvedDependenciesMap.putAll((Object)dependency.getScope(), DependencyResolverImpl.getFiles(dependency));
            if (!(dependency instanceof ExternalProjectDependency) || (mainSourceSet = this.findSourceSet(project = rootProject.findProject((projectDependency = (ExternalProjectDependency)dependency).getProjectPath()), "main")) == null) continue;
            result.addAll(DeprecatedDependencyResolver.collectSourceSetOutputDirsAsSingleEntryLibraries(mainSourceSet, runtimeClasspathOrder, dependency.getScope()));
        }
        compileClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)"COMPILE"));
        compileClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)"PROVIDED"));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)"RUNTIME"));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)"COMPILE"));
        runtimeClasspathFiles.removeAll(resolvedDependenciesMap.get((Object)"PROVIDED"));
        ArrayList<ExternalDependency> fileDependencies = new ArrayList<ExternalDependency>();
        fileDependencies.addAll(this.createLibraryDependenciesForFiles(compileClasspathFiles, "COMPILE"));
        fileDependencies.addAll(this.createLibraryDependenciesForFiles(runtimeClasspathFiles, "RUNTIME"));
        for (ExternalDependency dependency : fileDependencies) {
            this.updateDependencyOrder(compileClasspathOrder, runtimeClasspathOrder, dependency);
        }
        result.addAll(fileDependencies);
        result.addAll(this.createFileCollectionDependencies(compileClasspathFiles, compileClasspathOrder, "COMPILE"));
        result.addAll(this.createFileCollectionDependencies(runtimeClasspathFiles, runtimeClasspathOrder, "RUNTIME"));
        result.addAll(DeprecatedDependencyResolver.collectSourceSetOutputDirsAsSingleEntryLibraries(sourceSet, runtimeClasspathOrder, "RUNTIME"));
        this.collectProvidedDependencies(sourceSet, result);
        return DeprecatedDependencyResolver.removeDuplicates(result);
    }

    public void collectProvidedDependencies(@NotNull SourceSet sourceSet, @NotNull Collection<ExternalDependency> result) {
        Map scopes;
        Map map;
        IdeaPlugin ideaPlugin;
        if (sourceSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(4);
        }
        if (result == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(5);
        }
        final LinkedHashSet<Object> providedConfigurations = new LinkedHashSet<Object>();
        ArrayListMultimap filesToDependenciesMap = ArrayListMultimap.create();
        for (ExternalDependency dep : new DependencyTraverser(result)) {
            filesToDependenciesMap.put(DependencyResolverImpl.getFiles(dep), (Object)dep);
        }
        if (sourceSet.getName().equals("main") && this.myProject.getPlugins().findPlugin(WarPlugin.class) != null) {
            providedConfigurations.add(this.myProject.getConfigurations().findByName("providedCompile"));
            providedConfigurations.add(this.myProject.getConfigurations().findByName("providedRuntime"));
        }
        if ((ideaPlugin = (IdeaPlugin)this.myProject.getPlugins().findPlugin(IdeaPlugin.class)) != null && (map = (Map)(scopes = ideaPlugin.getModel().getModule().getScopes()).get("PROVIDED")) != null && map.get("plus") != null) {
            Iterable ideaPluginProvidedConfigurations = Iterables.filter((Iterable)((Iterable)map.get("plus")), (Predicate)new Predicate<Configuration>(){

                public boolean apply(Configuration cfg) {
                    return !cfg.getName().equals("compileClasspath") && !providedConfigurations.contains(cfg);
                }
            });
            for (Configuration configuration : ideaPluginProvidedConfigurations) {
                Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, "PROVIDED").getExternalDeps();
                for (ExternalDependency it : new DependencyTraverser(providedDependencies)) {
                    filesToDependenciesMap.put(DependencyResolverImpl.getFiles(it), (Object)it);
                }
                result.addAll(providedDependencies);
            }
        }
        for (Configuration configuration : providedConfigurations) {
            Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, "PROVIDED").getExternalDeps();
            for (ExternalDependency dep : new DependencyTraverser(providedDependencies)) {
                Collection dependencies = filesToDependenciesMap.get(DependencyResolverImpl.getFiles(dep));
                if (!dependencies.isEmpty()) {
                    if (dep.getDependencies().isEmpty()) {
                        providedDependencies.remove(dep);
                    }
                    for (ExternalDependency depForScope : dependencies) {
                        ((AbstractExternalDependency)depForScope).setScope("PROVIDED");
                    }
                    continue;
                }
                filesToDependenciesMap.put(DependencyResolverImpl.getFiles(dep), (Object)dep);
            }
            result.addAll(providedDependencies);
        }
    }

    public void updateDependencyOrder(Map<File, Integer> compileClasspathOrder, Map<File, Integer> runtimeClasspathOrder, ExternalDependency dependency) {
        String scope = dependency.getScope();
        Map<File, Integer> classpathOrderMap = scope == "COMPILE" || scope == "PROVIDED" ? compileClasspathOrder : (scope == "RUNTIME" ? runtimeClasspathOrder : null);
        Collection<File> depFiles = DependencyResolverImpl.getFiles(dependency);
        int order = this.getOrder(classpathOrderMap, depFiles);
        if (dependency instanceof AbstractExternalDependency) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(order);
        }
    }

    @NotNull
    private Collection<ExternalDependency> createFileCollectionDependencies(@NotNull Set<File> files, @NotNull Map<File, Integer> classPathOrder, @Nullable String scope) {
        if (files == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(6);
        }
        if (classPathOrder == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(7);
        }
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        if (files.isEmpty()) {
            ArrayList<ExternalDependency> arrayList = result;
            if (arrayList == null) {
                DeprecatedDependencyResolver.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(files);
        fileCollectionDependency.setScope(scope);
        fileCollectionDependency.setClasspathOrder(this.getOrder(classPathOrder, files));
        result.add(fileCollectionDependency);
        for (File file : files) {
            SourceSet outputDirSourceSet = this.mySourceSetFinder.findByArtifact(file.getPath());
            if (outputDirSourceSet == null) continue;
            result.addAll(DeprecatedDependencyResolver.collectSourceSetOutputDirsAsSingleEntryLibraries(outputDirSourceSet, classPathOrder, scope));
        }
        ArrayList<ExternalDependency> arrayList = result;
        if (arrayList == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public SourceSet findSourceSet(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(10);
        }
        if (project == null) {
            return null;
        }
        SourceSetContainer sourceSets = JavaPluginUtil.getSourceSetContainer(project);
        return sourceSets == null ? null : (SourceSet)sourceSets.findByName(name);
    }

    public int getOrder(@Nullable Map<File, Integer> classpathOrderMap, @NotNull Collection<File> files) {
        if (files == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(11);
        }
        int order = -1;
        for (File file : files) {
            if (classpathOrderMap == null) continue;
            Integer fileOrder = classpathOrderMap.get(file);
            if (fileOrder != null && (order == -1 || fileOrder < order)) {
                order = fileOrder;
            }
            if (order != 0) continue;
            break;
        }
        return order;
    }

    @NotNull
    public Map<File, Integer> addIterationOrder(Set<File> files) {
        int order = 0;
        LinkedHashMap<File, Integer> fileToOrder = new LinkedHashMap<File, Integer>();
        for (File file : files) {
            fileToOrder.put(file, order++);
        }
        LinkedHashMap<File, Integer> linkedHashMap = fileToOrder;
        if (linkedHashMap == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @NotNull
    public Set<File> getCompileClasspathFiles(@NotNull SourceSet sourceSet, String ... languages) {
        if (sourceSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(13);
        }
        ArrayList jvmLanguages = Lists.newArrayList((Object[])languages);
        final String sourceSetCompileTaskPrefix = sourceSet.getName() == "main" ? "" : sourceSet.getName();
        List compileTaskNames = Lists.transform((List)jvmLanguages, (Function)new Function<String, String>(){

            public String apply(String s) {
                return "compile" + StringGroovyMethods.capitalize((String)sourceSetCompileTaskPrefix) + s;
            }
        });
        LinkedHashSet compileClasspathFiles = new LinkedHashSet();
        for (String task : compileTaskNames) {
            Task compileTask = (Task)this.myProject.getTasks().findByName(task);
            if (!(compileTask instanceof AbstractCompile)) continue;
            try {
                ArrayList files = new ArrayList(((AbstractCompile)compileTask).getClasspath().getFiles());
                files.removeAll(compileClasspathFiles);
                compileClasspathFiles.addAll(files);
            }
            catch (Exception exception) {}
        }
        try {
            compileClasspathFiles = compileClasspathFiles.isEmpty() ? new LinkedHashSet(sourceSet.getCompileClasspath().getFiles()) : compileClasspathFiles;
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashSet linkedHashSet = compileClasspathFiles;
        if (linkedHashSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(14);
        }
        return linkedHashSet;
    }

    public Set<File> getRuntimeClasspathFiles(@NotNull SourceSet sourceSet) {
        if (sourceSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(15);
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        try {
            result.addAll(sourceSet.getRuntimeClasspath().getFiles());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @NotNull
    public Multimap<Object, ExternalDependency> collectCompileDependencies(CompileDependenciesProvider compileDependenciesProvider, RuntimeDependenciesProvider runtimeDependenciesProvider) {
        HashMultimap filesToDependenciesMap = HashMultimap.create();
        Collection<ExternalDependency> compileDependencies = compileDependenciesProvider.getDependencies();
        for (ExternalDependency dep : new DependencyTraverser(compileDependencies)) {
            Collection<File> resolvedFiles = DependencyResolverImpl.getFiles(dep);
            filesToDependenciesMap.put(resolvedFiles, (Object)dep);
            this.markAsProvidedIfNeeded(compileDependenciesProvider, runtimeDependenciesProvider, (AbstractExternalDependency)dep);
        }
        HashMultimap hashMultimap = filesToDependenciesMap;
        if (hashMultimap == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(16);
        }
        return hashMultimap;
    }

    @NotNull
    public Multimap<Object, ExternalDependency> filterCompileDepsFromRuntime(Collection<ExternalDependency> runtimeDependencies, Multimap<Object, ExternalDependency> filesToCompileDependenciesMap) {
        ArrayListMultimap resolvedRuntimeMap = ArrayListMultimap.create();
        for (ExternalDependency dep : new DependencyTraverser(runtimeDependencies)) {
            boolean hasCompileDependencies;
            Collection<File> resolvedFiles = DependencyResolverImpl.getFiles(dep);
            Collection dependencies = filesToCompileDependenciesMap.get(resolvedFiles);
            boolean bl = hasCompileDependencies = dependencies != null && !dependencies.isEmpty();
            if (hasCompileDependencies && dep.getDependencies().isEmpty()) {
                runtimeDependencies.remove(dep);
                for (ExternalDependency dependency : dependencies) {
                    ((AbstractExternalDependency)dependency).setScope("COMPILE");
                }
                continue;
            }
            if (hasCompileDependencies) {
                ((AbstractExternalDependency)dep).setScope("COMPILE");
            }
            resolvedRuntimeMap.put(resolvedFiles, (Object)dep);
        }
        ArrayListMultimap arrayListMultimap = resolvedRuntimeMap;
        if (arrayListMultimap == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(17);
        }
        return arrayListMultimap;
    }

    public void markAsProvidedIfNeeded(@NotNull CompileDependenciesProvider compileDependenciesProvider, @NotNull RuntimeDependenciesProvider runtimeDependenciesProvider, @NotNull AbstractExternalDependency dep) {
        boolean checkCompileOnlyDeps;
        if (compileDependenciesProvider == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(18);
        }
        if (runtimeDependenciesProvider == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(19);
        }
        if (dep == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(20);
        }
        Collection<File> resolvedFiles = DependencyResolverImpl.getFiles(dep);
        boolean bl = checkCompileOnlyDeps = compileDependenciesProvider.getCompileClasspathConfiguration() != null;
        if (isJavaLibraryPluginSupported) {
            Set<File> deprecatedCompileConfigurationFiles;
            Set<File> compileOnlyConfigurationFiles = compileDependenciesProvider.getCompileOnlyConfigurationFiles();
            if (compileOnlyConfigurationFiles != null && compileOnlyConfigurationFiles.containsAll(resolvedFiles) && ((deprecatedCompileConfigurationFiles = compileDependenciesProvider.getDeprecatedCompileConfigurationFiles()) == null || !deprecatedCompileConfigurationFiles.containsAll(resolvedFiles))) {
                dep.setScope("PROVIDED");
            }
        } else if (checkCompileOnlyDeps && !compileDependenciesProvider.getCompileConfigurationFiles().containsAll(resolvedFiles) && !runtimeDependenciesProvider.getConfigurationFiles().containsAll(resolvedFiles)) {
            dep.setScope("PROVIDED");
        }
    }

    @NotNull
    public static List<ExternalDependency> removeDuplicates(Collection<ExternalDependency> result) {
        new DeduplicationVisitor().visit(result);
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(result, (Predicate)Predicates.not((Predicate)Predicates.isNull())));
        if (arrayList == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static boolean seenAllFiles(@NotNull ExternalDependency seenDependency, @NotNull ExternalDependency nextDependency) {
        if (seenDependency == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(22);
        }
        if (nextDependency == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(23);
        }
        Collection<File> seenFiles = DependencyResolverImpl.getFiles(seenDependency);
        Collection<File> nextFiles = DependencyResolverImpl.getFiles(nextDependency);
        boolean filesSeen = seenFiles.containsAll(nextFiles);
        boolean projectDependencySeen = DeprecatedDependencyResolver.compareAsProjectDependencies(seenDependency, nextDependency);
        return filesSeen || projectDependencySeen;
    }

    private static boolean compareAsProjectDependencies(@NotNull ExternalDependency seenDependency, @NotNull ExternalDependency newDependency) {
        if (seenDependency == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(24);
        }
        if (newDependency == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(25);
        }
        if (seenDependency instanceof ExternalProjectDependency && newDependency instanceof ExternalProjectDependency) {
            String seenConfiguration = ((ExternalProjectDependency)seenDependency).getConfigurationName();
            String newConfiguration = ((ExternalProjectDependency)newDependency).getConfigurationName();
            return seenDependency.getId().equals(newDependency.getId()) && (seenConfiguration == newConfiguration || seenConfiguration != null && seenConfiguration.equals(newConfiguration));
        }
        return false;
    }

    private static void upgradeScopeIfNeeded(@NotNull ExternalDependency targetDependency, @NotNull String newScope) {
        if (targetDependency == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(26);
        }
        if (newScope == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(27);
        }
        if (targetDependency.getScope().equals("COMPILE") || !(targetDependency instanceof AbstractExternalDependency)) {
            return;
        }
        AbstractExternalDependency dep = (AbstractExternalDependency)targetDependency;
        if (newScope.equals("COMPILE")) {
            dep.setScope("COMPILE");
        }
        if (dep.getScope().equals("RUNTIME") && newScope.equals("PROVIDED") || dep.getScope().equals("PROVIDED") && newScope.equals("RUNTIME")) {
            dep.setScope("COMPILE");
        }
    }

    private static Collection<ExternalDependency> collectSourceSetOutputDirsAsSingleEntryLibraries(@NotNull SourceSet sourceSet, @NotNull Map<File, Integer> classpathOrder, @Nullable String scope) {
        if (sourceSet == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(28);
        }
        if (classpathOrder == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(29);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        Set runtimeOutputDirs = sourceSet.getOutput().getDirs().getFiles();
        for (File dir : runtimeOutputDirs) {
            DefaultFileCollectionDependency runtimeOutputDirsDependency = new DefaultFileCollectionDependency(Collections.singleton(dir));
            runtimeOutputDirsDependency.setScope(scope);
            Integer fileOrder = classpathOrder.get(dir);
            runtimeOutputDirsDependency.setClasspathOrder(fileOrder != null ? fileOrder : -1);
            result.add(runtimeOutputDirsDependency);
        }
        return result;
    }

    @Nullable
    ExternalLibraryDependency resolveLibraryByPath(File file, String scope) {
        return DeprecatedDependencyResolver.resolveLibraryByPath(this.myProject, file, scope);
    }

    @Nullable
    static ExternalLibraryDependency resolveLibraryByPath(Project project, File file, String scope) {
        File modules2Dir = new File(project.getGradle().getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        return DeprecatedDependencyResolver.resolveLibraryByPath(file, modules2Dir, scope);
    }

    @Nullable
    static ExternalLibraryDependency resolveLibraryByPath(File file, File modules2Dir, String scope) {
        File sourcesFile = null;
        try {
            String modules2Path = modules2Dir.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(modules2Path)) {
                File[] hashDirs;
                ArrayList<File> parents = new ArrayList<File>();
                for (File parent = file.getParentFile(); parent != null && !parent.getName().equals(modules2Dir.getName()); parent = parent.getParentFile()) {
                    parents.add(parent);
                }
                File groupDir = (File)parents.get(parents.size() - 1);
                File artifactDir = (File)parents.get(parents.size() - 2);
                File versionDir = (File)parents.get(parents.size() - 3);
                if (versionDir != null && (hashDirs = versionDir.listFiles()) != null) {
                    for (File hashDir : hashDirs) {
                        File[] sourcesJars = hashDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith("sources.jar");
                            }
                        });
                        if (sourcesJars == null || sourcesJars.length <= 0) continue;
                        sourcesFile = sourcesJars[0];
                        break;
                    }
                    String packaging = DeprecatedDependencyResolver.resolvePackagingType(file);
                    String classifier = DeprecatedDependencyResolver.resolveClassifier(artifactDir.getName(), versionDir.getName(), file);
                    DefaultExternalLibraryDependency defaultDependency = new DefaultExternalLibraryDependency();
                    defaultDependency.setName(artifactDir.getName());
                    defaultDependency.setGroup(groupDir.getName());
                    defaultDependency.setPackaging(packaging);
                    defaultDependency.setClassifier(classifier);
                    defaultDependency.setVersion(versionDir.getName());
                    defaultDependency.setFile(file);
                    defaultDependency.setSource(sourcesFile);
                    defaultDependency.setScope(scope);
                    return defaultDependency;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    Collection<ExternalDependency> createLibraryDependenciesForFiles(@NotNull Set<File> fileDependencies, @Nullable String scope) {
        if (fileDependencies == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(30);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        File modules2Dir = new File(this.myProject.getGradle().getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        ArrayList<File> toRemove = new ArrayList<File>();
        for (File file : fileDependencies) {
            ExternalLibraryDependency libraryDependency = DeprecatedDependencyResolver.resolveLibraryByPath(file, modules2Dir, scope);
            if (libraryDependency != null) {
                result.add((ExternalDependency)libraryDependency);
                toRemove.add(file);
                continue;
            }
            String name = DeprecatedDependencyResolver.getNameWithoutExtension(file);
            File sourcesFile = new File(file.getParentFile(), name + "-sources.jar");
            if (!sourcesFile.exists()) continue;
            libraryDependency = new DefaultExternalLibraryDependency();
            DefaultExternalLibraryDependency defLD = (DefaultExternalLibraryDependency)libraryDependency;
            defLD.setFile(file);
            defLD.setSource(sourcesFile);
            defLD.setScope(scope);
            result.add((ExternalDependency)libraryDependency);
            toRemove.add(file);
        }
        fileDependencies.removeAll(toRemove);
        return result;
    }

    @NotNull
    static String resolvePackagingType(File file) {
        if (file == null) {
            return "jar";
        }
        String path = file.getPath();
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return "jar";
        }
        String string = path.substring(index + 1);
        if (string == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    static String resolveClassifier(String name, String version, File file) {
        Matcher matcher;
        String libraryFileName = DeprecatedDependencyResolver.getNameWithoutExtension(file);
        String mavenLibraryFileName = name + "-" + version;
        if (!mavenLibraryFileName.equals(libraryFileName) && (matcher = Pattern.compile(name + "-" + version + "-(.*)").matcher(libraryFileName)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    static String getNameWithoutExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static Set<ExternalDependency> findAllFileDependencies(Collection<Dependency> dependencies, String scope) {
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        for (Dependency dep : dependencies) {
            try {
                Set files;
                if (!(dep instanceof SelfResolvingDependency) || dep instanceof ProjectDependency || (files = ((SelfResolvingDependency)dep).resolve()) == null || files.isEmpty()) continue;
                DefaultFileCollectionDependency dependency = new DefaultFileCollectionDependency(files);
                dependency.setScope(scope);
                result.add(dependency);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private Set<ExternalDependency> findDependencies(@NotNull Configuration configuration, @NotNull Collection<Dependency> dependencies, @Nullable String scope) {
        if (configuration == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(32);
        }
        if (dependencies == null) {
            DeprecatedDependencyResolver.$$$reportNull$$$0(33);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        Set resolvedArtifacts = this.myIsPreview ? Collections.emptySet() : configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL);
        ArrayListMultimap artifactMap = ArrayListMultimap.create();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            artifactMap.put((Object)DeprecatedDependencyResolver.toMyModuleIdentifier(artifact.getModuleVersion().getId()), (Object)artifact);
        }
        for (Dependency it : dependencies) {
            try {
                if (it instanceof ProjectDependency) {
                    Project project = ((ProjectDependency)it).getDependencyProject();
                    Configuration targetConfiguration = DeprecatedDependencyResolver.getTargetConfiguration((ProjectDependency)it);
                    DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
                    projectDependency.setName(project.getName());
                    projectDependency.setGroup(project.getGroup().toString());
                    projectDependency.setVersion(project.getVersion().toString());
                    projectDependency.setScope(scope);
                    projectDependency.setProjectPath(project.getPath());
                    projectDependency.setConfigurationName(targetConfiguration == null ? "default" : targetConfiguration.getName());
                    LinkedHashSet<File> artifacts = new LinkedHashSet<File>(targetConfiguration == null ? Collections.emptySet() : targetConfiguration.getAllArtifacts().getFiles().getFiles());
                    projectDependency.setProjectDependencyArtifacts(artifacts);
                    projectDependency.setProjectDependencyArtifactsSources(DependencyResolverImpl.findArtifactSources(artifacts, this.mySourceSetFinder));
                    result.add(projectDependency);
                    continue;
                }
                if (it == null) continue;
                Collection artifactsResult = artifactMap.get((Object)DeprecatedDependencyResolver.toMyModuleIdentifier(it.getName(), it.getGroup()));
                if (artifactsResult != null && !artifactsResult.isEmpty()) {
                    ResolvedArtifact artifact = (ResolvedArtifact)artifactsResult.iterator().next();
                    String packaging = artifact.getExtension() != null ? artifact.getExtension() : "jar";
                    String classifier = artifact.getClassifier();
                    ExternalLibraryDependency resolvedDep = this.resolveLibraryByPath(artifact.getFile(), scope);
                    File sourcesFile = resolvedDep == null ? null : resolvedDep.getSource();
                    DefaultExternalLibraryDependency libraryDependency = new DefaultExternalLibraryDependency();
                    libraryDependency.setName(it.getName());
                    libraryDependency.setGroup(it.getGroup());
                    libraryDependency.setPackaging(packaging);
                    libraryDependency.setClassifier(classifier);
                    libraryDependency.setVersion(artifact.getModuleVersion().getId().getVersion());
                    libraryDependency.setScope(scope);
                    libraryDependency.setFile(artifact.getFile());
                    libraryDependency.setSource(sourcesFile);
                    result.add(libraryDependency);
                    continue;
                }
                if (it instanceof SelfResolvingDependency || this.myIsPreview) continue;
                DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
                dependency.setName(it.getName());
                dependency.setGroup(it.getGroup());
                dependency.setVersion(it.getVersion());
                dependency.setScope(scope);
                dependency.setFailureMessage("Could not find " + it.getGroup() + ":" + it.getName() + ":" + it.getVersion());
                result.add(dependency);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Nullable
    public static Configuration getTargetConfiguration(ProjectDependency projectDependency) {
        try {
            return !is4OrBetter ? (Configuration)projectDependency.getClass().getMethod("getProjectConfiguration", new Class[0]).invoke((Object)projectDependency, new Object[0]) : (Configuration)projectDependency.getDependencyProject().getConfigurations().findByName(projectDependency.getTargetConfiguration() != null ? projectDependency.getTargetConfiguration() : "default");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isProjectDependencyArtifact(ResolvedArtifact artifact) {
        return isDependencySubstitutionsSupported && artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier;
    }

    private static MyModuleIdentifier toMyModuleIdentifier(ModuleVersionIdentifier id) {
        return new MyModuleIdentifier(id.getName(), id.getGroup());
    }

    private static MyModuleIdentifier toMyModuleIdentifier(String name, String group) {
        return new MyModuleIdentifier(name, group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetFinder";
                break;
            }
            case 2: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPathOrder";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/util/resolve/deprecated/DeprecatedDependencyResolver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileDependenciesProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeDependenciesProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenDependency";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextDependency";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDependency";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDependency";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpathOrder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDependencies";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/util/resolve/deprecated/DeprecatedDependencyResolver";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileCollectionDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addIterationOrder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileClasspathFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCompileDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCompileDepsFromRuntime";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackagingType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectDeps";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectProvidedDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileCollectionDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 31: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSourceSet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompileClasspathFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeClasspathFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "markAsProvidedIfNeeded";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "seenAllFiles";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compareAsProjectDependencies";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "upgradeScopeIfNeeded";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectSourceSetOutputDirsAsSingleEntryLibraries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependenciesForFiles";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeduplicationVisitor {
        private final Map<ExternalDependencyId, ExternalDependency> seenDependencies = new HashMap<ExternalDependencyId, ExternalDependency>();

        private DeduplicationVisitor() {
        }

        public void visit(@NotNull Collection<ExternalDependency> dependencies) {
            if (dependencies == null) {
                DeduplicationVisitor.$$$reportNull$$$0(0);
            }
            Iterator<ExternalDependency> iter = dependencies.iterator();
            while (iter.hasNext()) {
                ExternalDependency nextDependency = iter.next();
                ExternalDependencyId nextId = nextDependency.getId();
                ExternalDependency seenDependency = this.seenDependencies.get(nextId);
                Collection childDeps = nextDependency.getDependencies();
                if (seenDependency == null) {
                    this.seenDependencies.put(nextId, nextDependency);
                    this.visit(childDeps);
                    continue;
                }
                DeprecatedDependencyResolver.upgradeScopeIfNeeded(seenDependency, nextDependency.getScope());
                this.visit(childDeps);
                seenDependency.getDependencies().addAll(childDeps);
                if (!DeprecatedDependencyResolver.seenAllFiles(seenDependency, nextDependency)) continue;
                iter.remove();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/plugins/gradle/tooling/util/resolve/deprecated/DeprecatedDependencyResolver$DeduplicationVisitor", "visit"));
        }
    }
}

