/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticVariableRenamerKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0012\u0010\u0010\u001a\f0\u0005\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0012\u0010\u0013\u001a\f0\u0005\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0012\u0010\u0014\u001a\f0\u0005\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lcom/intellij/psi/PsiNamedElement;", "newClassName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/util/Collection;)V", "toUnpluralize", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "canonicalNameToName", "canonicalName", "element", "entityName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "getDialogTitle", "nameToCanonicalName", "name", "Companion", "kotlin.idea"})
public final class AutomaticVariableRenamer
extends AutomaticRenamer {
    private final ArrayList<KtNamedDeclaration> toUnpluralize;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getDialogTitle() {
        String string = JavaRefactoringBundle.message((String)"rename.variables.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaRefactoringBundle.me\u2026\"rename.variables.title\")");
        return string;
    }

    @NotNull
    public String getDialogDescription() {
        String string = JavaRefactoringBundle.message((String)"rename.variables.with.the.following.names.to", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaRefactoringBundle.me\u2026.the.following.names.to\")");
        return string;
    }

    @NotNull
    public String entityName() {
        String string = JavaRefactoringBundle.message((String)"entity.name.variable", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaRefactoringBundle.me\u2026e(\"entity.name.variable\")");
        return string;
    }

    @Nullable
    protected String nameToCanonicalName(@NotNull String name2, @NotNull PsiNamedElement element3) {
        String string;
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!(element3 instanceof KtNamedDeclaration)) {
                return name2;
            }
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)element3));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PsiVariable psiVariable = v0;
        if (psiVariable != null) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
            string = codeStyleManager.variableNameToPropertyName(name2, codeStyleManager.getVariableKind(psiVariable));
        } else {
            string = name2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (psiVariable != null)\u2026ble))\n        } else name");
        String propertyName = string;
        if (this.toUnpluralize.contains(element3)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.toUnpluralize.remove(element3);
        }
        return propertyName;
    }

    @Nullable
    protected String canonicalNameToName(@NotNull String canonicalName, @NotNull PsiNamedElement element3) {
        String string;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!(element3 instanceof KtNamedDeclaration)) {
                return canonicalName;
            }
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)element3));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        PsiVariable psiVariable = v0;
        if (psiVariable != null) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
            string = codeStyleManager.propertyNameToVariableName(canonicalName, codeStyleManager.getVariableKind(psiVariable));
        } else {
            string = canonicalName;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (psiVariable != null)\u2026     } else canonicalName");
        String varName = string;
        return this.toUnpluralize.contains(element3) ? StringUtil.pluralize((String)varName) : varName;
    }

    public AutomaticVariableRenamer(@NotNull PsiNamedElement klass2, @NotNull String newClassName, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)newClassName, (String)"newClassName");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        this.toUnpluralize = new ArrayList();
        for (UsageInfo usageInfo : usages2) {
            KotlinType type2;
            DeclarationDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor;
            KtCallableDeclaration parameterOrVariable;
            PsiElement usageElement;
            if (usageInfo.getElement() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)usageElement, (String)"usage.element ?: continue");
            if ((KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{KtVariableDeclaration.class, KtParameter.class}) == null) {
                continue;
            }
            KtTypeReference ktTypeReference = parameterOrVariable.getTypeReference();
            if (ktTypeReference == null) continue;
            if (!PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)ktTypeReference), (PsiElement)usageElement, (boolean)false, (int)2, null)) {
                continue;
            }
            try {
                declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)((KtDeclaration)parameterOrVariable), null, (int)1, null);
            }
            catch (NoDescriptorForDeclarationException e) {
                LOG.error((Throwable)e);
                continue;
            }
            DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
            if (declarationDescriptor2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            Intrinsics.checkNotNullExpressionValue((Object)((VariableDescriptor)declarationDescriptor2).getType(), (String)"(descriptor as VariableDescriptor).type");
            if (AutomaticVariableRenamerKt.access$isCollectionLikeOf(type2, klass2)) {
                this.toUnpluralize.add((KtNamedDeclaration)parameterOrVariable);
            }
            this.myElements.add(parameterOrVariable);
        }
        String string = klass2.getName();
        this.suggestAllNames(string != null ? FrontendIndependentPsiUtilsKt.unquote((String)string) : null, FrontendIndependentPsiUtilsKt.unquote((String)newClassName));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(AutomaticVariableRenamer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Autom\u2026iableRenamer::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

