/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFix;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "expression", "operation", "", "notNullNeeded", "", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Ljava/lang/String;Z)V", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionName;", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "elementsBetweenReceiverAndOperation", "", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public abstract class ReplaceCallFix
extends KotlinQuickFixAction<KtQualifiedExpression> {
    private final String operation;
    private final boolean notNullNeeded;

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)this.getElement();
        if (ktQualifiedExpression == null) {
            return false;
        }
        KtQualifiedExpression element3 = ktQualifiedExpression;
        return element3.getSelectorExpression() != null;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)this.getElement();
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression element3 = ktQualifiedExpression;
        String elvis2 = ReplaceCallFixUtilsKt.elvisOrEmpty((KtExpression)element3, this.notNullNeeded);
        String betweenReceiverAndOperation2 = CollectionsKt.joinToString$default((Iterable)this.elementsBetweenReceiverAndOperation(element3), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.betweenReceiverAndOperation.1.INSTANCE, (int)30, null);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
        String string = "$0" + betweenReceiverAndOperation2 + this.operation + "$1" + elvis2;
        Object[] objectArray = new Object[2];
        objectArray[0] = element3.getReceiverExpression();
        KtExpression ktExpression = element3.getSelectorExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        objectArray[1] = ktExpression;
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement replacement2 = element3.replace((PsiElement)newExpression2);
        CharSequence charSequence = elvis2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            PsiElement psiElement2 = replacement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"replacement");
            ReplaceCallFixUtilsKt.moveCaretToEnd(psiElement2, editor2, project2);
        }
    }

    private final List<PsiElement> elementsBetweenReceiverAndOperation(KtQualifiedExpression $this$elementsBetweenReceiverAndOperation) {
        Object object;
        PsiElement start;
        block11: {
            block10: {
                boolean bl;
                Object object2;
                PsiElement operation2;
                KtExpression receiver;
                block9: {
                    block8: {
                        receiver = $this$elementsBetweenReceiverAndOperation.getReceiverExpression();
                        ASTNode aSTNode = $this$elementsBetweenReceiverAndOperation.getOperationTokenNode();
                        if (!(aSTNode instanceof PsiElement)) {
                            aSTNode = null;
                        }
                        PsiElement psiElement2 = (PsiElement)aSTNode;
                        if (psiElement2 == null) {
                            return CollectionsKt.emptyList();
                        }
                        operation2 = psiElement2;
                        object2 = receiver.getNextSibling();
                        if (object2 == null) break block8;
                        PsiElement psiElement3 = object2;
                        boolean bl2 = false;
                        bl = false;
                        PsiElement it = psiElement3;
                        boolean bl3 = false;
                        object2 = Intrinsics.areEqual((Object)it, (Object)operation2) ^ true ? psiElement3 : null;
                        if (object2 != null) break block9;
                    }
                    return CollectionsKt.emptyList();
                }
                start = object2;
                object = operation2.getPrevSibling();
                if (object == null) break block10;
                PsiElement psiElement4 = object;
                bl = false;
                boolean bl4 = false;
                PsiElement it = psiElement4;
                boolean bl5 = false;
                object = Intrinsics.areEqual((Object)it, (Object)receiver) ^ true ? psiElement4 : null;
                if (object != null) break block11;
            }
            return CollectionsKt.emptyList();
        }
        PsiElement end = object;
        List list = PsiTreeUtil.getElementsOfRange((PsiElement)start, (PsiElement)end);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PsiTreeUtil.getElementsOfRange(start, end)");
        return list;
    }

    public ReplaceCallFix(@NotNull KtQualifiedExpression expression2, @NotNull String operation2, boolean notNullNeeded) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)operation2, (String)"operation");
        super((PsiElement)expression2);
        this.operation = operation2;
        this.notNullNeeded = notNullNeeded;
    }

    public /* synthetic */ ReplaceCallFix(KtQualifiedExpression ktQualifiedExpression, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(ktQualifiedExpression, string, bl);
    }
}

