/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddReturnToUnusedLastExpressionInFunctionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "isLastStatementInFunctionBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Factory", "kotlin.idea"})
public final class AddReturnToUnusedLastExpressionInFunctionFix
extends KotlinQuickFixAction<KtElement> {
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.return.before.expression", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object t = this.getElement();
        if (!(t instanceof KtExpression)) {
            t = null;
        }
        KtExpression ktExpression = (KtExpression)t;
        if (ktExpression == null) {
            return false;
        }
        KtExpression expr2 = ktExpression;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)expr2), (BodyResolveMode)BodyResolveMode.PARTIAL);
        if (!this.isLastStatementInFunctionBody(expr2)) {
            return false;
        }
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)expr2, (BindingContext)context2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType exprType = kotlinType;
        if (KotlinTypeKt.isError((KotlinType)exprType)) {
            return false;
        }
        PsiElement psiElement2 = expr2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"expr.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtNamedFunction)) {
            psiElement3 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function2 = ktNamedFunction;
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default((KtNamedFunction)function2, null, (int)1, null);
        if (functionDescriptor2 == null || (functionDescriptor2 = functionDescriptor2.getReturnType()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor2, (String)"function.resolveToDescri\u2026eturnType ?: return false");
        FunctionDescriptor functionReturnType = functionDescriptor2;
        return !KotlinTypeKt.isError((KotlinType)functionReturnType) && TypeUtilsKt.isSubtypeOf((KotlinType)exprType, (KotlinType)functionReturnType);
    }

    private final boolean isLastStatementInFunctionBody(KtExpression $this$isLastStatementInFunctionBody) {
        PsiElement psiElement2 = $this$isLastStatementInFunctionBody.getParent();
        if (!(psiElement2 instanceof KtBlockExpression)) {
            psiElement2 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement2;
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression body2 = ktBlockExpression;
        List list = body2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"body.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list);
        if (ktExpression == null) {
            return false;
        }
        KtExpression last = ktExpression;
        return last == $this$isLastStatementInFunctionBody;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element3 = ktElement;
        element3.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createExpression("return " + element3.getText()));
    }

    public AddReturnToUnusedLastExpressionInFunctionFix(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddReturnToUnusedLastExpressionInFunctionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Override
        @NotNull
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Diagnostic diagnostic2 = Errors.UNUSED_EXPRESSION.cast(diagnostic);
            Intrinsics.checkNotNullExpressionValue((Object)diagnostic2, (String)"Errors.UNUSED_EXPRESSION.cast(diagnostic)");
            SimpleDiagnostic casted = (SimpleDiagnostic)diagnostic2;
            PsiElement psiElement2 = casted.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"casted.psiElement");
            return new AddReturnToUnusedLastExpressionInFunctionFix((KtElement)psiElement2);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

