/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0006\u0010\u0016\u001a\u00020\u0012J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "Lcom/intellij/pom/Navigatable;", "parentDescriptor", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isBase", "", "navigateToReference", "(Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lorg/jetbrains/kotlin/psi/KtElement;ZZ)V", "javaDelegate", "Lcom/intellij/ide/hierarchy/call/CallHierarchyNodeDescriptor;", "references", "", "Lcom/intellij/psi/PsiReference;", "usageCount", "", "addReference", "", "reference", "canNavigate", "canNavigateToSource", "incrementUsageCount", "isValid", "navigate", "requestFocus", "update", "Companion", "kotlin.idea"})
public final class KotlinCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int usageCount;
    private final Set<PsiReference> references;
    private final CallHierarchyNodeDescriptor javaDelegate;
    public static final Companion Companion = new Companion(null);

    public final void incrementUsageCount() {
        int n = this.usageCount;
        this.usageCount = n + 1;
        this.javaDelegate.incrementUsageCount();
    }

    public final void addReference(@NotNull PsiReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        this.references.add(reference2);
        this.javaDelegate.addReference(reference2);
    }

    public boolean isValid() {
        PsiElement myElement = this.getPsiElement();
        return myElement != null && myElement.isValid();
    }

    /*
     * WARNING - void declaration
     */
    public boolean update() {
        String string;
        Icon icon;
        PsiElement targetElement;
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        Icon oldIcon = this.getIcon();
        int flags = this.isMarkReadOnly() ? 3 : 1;
        boolean changes = super.update();
        String elementText = KotlinCallHierarchyNodeDescriptor.Companion.renderElement(this.getPsiElement());
        if (elementText == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            CompositeAppearance compositeAppearance2 = this.myHighlightedText;
            Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance2, (String)"myHighlightedText");
            String string2 = compositeAppearance2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myHighlightedText.text");
            String string3 = invalidPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"invalidPrefix");
            if (!StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) {
                CompositeAppearance compositeAppearance3 = this.myHighlightedText;
                Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance3, (String)"myHighlightedText");
                compositeAppearance3.getBeginning().addText(invalidPrefix, KotlinCallHierarchyNodeDescriptor.access$getInvalidPrefixAttributes$s865990790());
            }
            return true;
        }
        PsiElement psiElement2 = targetElement = this.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement2);
        Icon elementIcon = psiElement2.getIcon(flags);
        KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor = this;
        if (changes && this.myIsBase) {
            void $this$apply;
            LayeredIcon layeredIcon = new LayeredIcon(2);
            boolean bl = false;
            boolean bl2 = false;
            LayeredIcon layeredIcon2 = layeredIcon;
            KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor2 = kotlinCallHierarchyNodeDescriptor;
            boolean bl3 = false;
            $this$apply.setIcon(elementIcon, 0);
            Icon icon2 = AllIcons.General.Modified;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.General.Modified");
            $this$apply.setIcon(AllIcons.General.Modified, 1, -icon2.getIconWidth() / 2, 0);
            Unit unit = Unit.INSTANCE;
            kotlinCallHierarchyNodeDescriptor = kotlinCallHierarchyNodeDescriptor2;
            icon = (Icon)layeredIcon;
        } else {
            icon = elementIcon;
        }
        kotlinCallHierarchyNodeDescriptor.setIcon(icon);
        TextAttributes mainTextAttributes = this.myColor != null ? new TextAttributes(this.myColor, null, null, null, 0) : null;
        CompositeAppearance compositeAppearance4 = this.myHighlightedText = new CompositeAppearance();
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance4, (String)"myHighlightedText");
        compositeAppearance4.getEnding().addText(elementText, mainTextAttributes);
        if (this.usageCount > 1) {
            CompositeAppearance compositeAppearance5 = this.myHighlightedText;
            Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance5, (String)"myHighlightedText");
            compositeAppearance5.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.usageCount}), KotlinCallHierarchyNodeDescriptor.access$getUsageCountPrefixAttributes$s865990790());
        }
        if ((string = KtPsiUtil.getPackageName((KtElement)((KtElement)targetElement))) == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtPsiUtil.getPackageName\u2026ement as KtElement) ?: \"\"");
        String packageName = string;
        CompositeAppearance compositeAppearance6 = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance6, (String)"myHighlightedText");
        compositeAppearance6.getEnding().addText("  (" + packageName + ')', KotlinCallHierarchyNodeDescriptor.access$getPackageNameAttributes$s865990790());
        CompositeAppearance compositeAppearance7 = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance7, (String)"myHighlightedText");
        this.myName = compositeAppearance7.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void navigate(boolean requestFocus) {
        this.javaDelegate.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.javaDelegate.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.javaDelegate.canNavigateToSource();
    }

    public KotlinCallHierarchyNodeDescriptor(@Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull KtElement element3, boolean isBase, boolean navigateToReference) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super(element3.getProject(), (NodeDescriptor)parentDescriptor, (PsiElement)element3, isBase);
        this.usageCount = 1;
        this.references = new HashSet();
        this.javaDelegate = new CallHierarchyNodeDescriptor(this.myProject, null, (PsiElement)element3, isBase, navigateToReference);
    }

    public static final /* synthetic */ TextAttributes access$getInvalidPrefixAttributes$s865990790() {
        return HierarchyNodeDescriptor.getInvalidPrefixAttributes();
    }

    public static final /* synthetic */ TextAttributes access$getUsageCountPrefixAttributes$s865990790() {
        return HierarchyNodeDescriptor.getUsageCountPrefixAttributes();
    }

    public static final /* synthetic */ TextAttributes access$getPackageNameAttributes$s865990790() {
        return HierarchyNodeDescriptor.getPackageNameAttributes();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor$Companion;", "", "()V", "renderClassOrObject", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "renderElement", "element", "Lcom/intellij/psi/PsiElement;", "renderNamedFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "kotlin.idea"})
    public static final class Companion {
        private final String renderElement(PsiElement element3) {
            PsiElement psiElement2 = element3;
            if (psiElement2 instanceof KtFile) {
                return ((KtFile)element3).getName();
            }
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny((KtDeclaration)((KtDeclaration)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            String elementText = null;
            PsiElement psiElement3 = element3;
            if (psiElement3 instanceof KtClassOrObject) {
                if (element3 instanceof KtObjectDeclaration && ((KtObjectDeclaration)element3).isCompanion()) {
                    DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
                    if (!(containingDescriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    descriptor2 = containingDescriptor;
                    elementText = this.renderClassOrObject((ClassDescriptor)descriptor2);
                } else if (element3 instanceof KtEnumEntry) {
                    elementText = ((KtEnumEntry)element3).getName();
                } else {
                    String string;
                    if (((KtClassOrObject)element3).getName() != null) {
                        DeclarationDescriptor declarationDescriptor2 = descriptor2;
                        if (declarationDescriptor2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        string = this.renderClassOrObject((ClassDescriptor)declarationDescriptor2);
                    } else {
                        string = KotlinBundle.message("hierarchy.text.anonymous", new Object[0]);
                    }
                    elementText = string;
                }
            } else if (psiElement3 instanceof KtNamedFunction || psiElement3 instanceof KtConstructor) {
                if (!(descriptor2 instanceof FunctionDescriptor)) {
                    return null;
                }
                elementText = this.renderNamedFunction((FunctionDescriptor)descriptor2);
            } else if (psiElement3 instanceof KtProperty) {
                elementText = ((KtProperty)element3).getName();
            } else {
                return null;
            }
            if (elementText == null) {
                return null;
            }
            String containerText = null;
            for (DeclarationDescriptor containerDescriptor = descriptor2.getContainingDeclaration(); containerDescriptor != null && !(containerDescriptor instanceof PackageFragmentDescriptor) && !(containerDescriptor instanceof ModuleDescriptor); containerDescriptor = containerDescriptor.getContainingDeclaration()) {
                String identifier;
                Name name2;
                Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor.getName(), (String)"containerDescriptor.name");
                if (name2.isSpecial()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name2.getIdentifier(), (String)"name.identifier");
                containerText = containerText != null ? identifier + '.' + containerText : identifier;
            }
            return containerText != null ? containerText + '.' + elementText : elementText;
        }

        @NotNull
        public final String renderNamedFunction(@NotNull FunctionDescriptor descriptor2) {
            ConstructorDescriptor constructorDescriptor;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            FunctionDescriptor functionDescriptor2 = descriptor2;
            if (!(functionDescriptor2 instanceof ConstructorDescriptor)) {
                functionDescriptor2 = null;
            }
            DeclarationDescriptor descriptorForName = (constructorDescriptor = (ConstructorDescriptor)functionDescriptor2) != null && (constructorDescriptor = constructorDescriptor.getContainingDeclaration()) != null ? (DeclarationDescriptor)constructorDescriptor : (DeclarationDescriptor)descriptor2;
            String string = descriptorForName.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptorForName.name.asString()");
            String name2 = string;
            String string2 = StringUtil.join((Collection)descriptor2.getValueParameters(), (Function)renderNamedFunction.paramTypes.1.INSTANCE, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.join(\n       \u2026   \", \"\n                )");
            String paramTypes2 = string2;
            return name2 + '(' + paramTypes2 + ')';
        }

        private final String renderClassOrObject(ClassDescriptor descriptor2) {
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

