/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/LookupCancelService;", "", "()V", "lastReminiscence", "Lorg/jetbrains/kotlin/idea/completion/LookupCancelService$Reminiscence;", "lookupCancelListener", "Lcom/intellij/codeInsight/lookup/LookupListener;", "getLookupCancelListener$kotlin_idea", "()Lcom/intellij/codeInsight/lookup/LookupListener;", "disposeLastReminiscence", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposeLastReminiscence$kotlin_idea", "wasAutoPopupRecentlyCancelled", "", "offset", "", "Companion", "Reminiscence", "kotlin.idea"})
public final class LookupCancelService {
    @NotNull
    private final LookupListener lookupCancelListener = new LookupListener(this){
        final /* synthetic */ LookupCancelService this$0;

        public void lookupCanceled(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lookup lookup = event.getLookup();
            if (event.isCanceledExplicitly()) {
                Lookup lookup2 = lookup;
                Intrinsics.checkNotNullExpressionValue((Object)lookup2, (String)"lookup");
                if (lookup2.isCompletion()) {
                    Integer offset;
                    LookupElement lookupElement2 = lookup.getCurrentItem();
                    Integer n = offset = lookupElement2 != null ? (Integer)lookupElement2.getUserData(LookupCancelService.Companion.getAUTO_POPUP_AT()) : null;
                    if (offset != null) {
                        Reminiscence reminiscence = LookupCancelService.access$getLastReminiscence$p(this.this$0);
                        if (reminiscence != null) {
                            reminiscence.dispose();
                        }
                        int n2 = offset;
                        Editor editor2 = lookup.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"lookup.editor");
                        Document document = editor2.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"lookup.editor.document");
                        if (n2 <= document.getTextLength()) {
                            Editor editor3 = lookup.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"lookup.editor");
                            LookupCancelService.access$setLastReminiscence$p(this.this$0, new Reminiscence(editor3, offset));
                        }
                    }
                }
            }
        }
        {
            this.this$0 = this$0;
        }
    };
    private Reminiscence lastReminiscence;
    @NotNull
    private static final Key<Integer> AUTO_POPUP_AT;
    public static final Companion Companion;

    @NotNull
    public final LookupListener getLookupCancelListener$kotlin_idea() {
        return this.lookupCancelListener;
    }

    public final void disposeLastReminiscence$kotlin_idea(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Reminiscence reminiscence = this.lastReminiscence;
        if (Intrinsics.areEqual((Object)(reminiscence != null ? reminiscence.getEditor() : null), (Object)editor2)) {
            Reminiscence reminiscence2 = this.lastReminiscence;
            Intrinsics.checkNotNull((Object)reminiscence2);
            reminiscence2.dispose();
            this.lastReminiscence = null;
        }
    }

    public final boolean wasAutoPopupRecentlyCancelled(@NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Reminiscence reminiscence = this.lastReminiscence;
        return reminiscence != null ? reminiscence.matches(editor2, offset) : false;
    }

    static {
        Companion = new Companion(null);
        AUTO_POPUP_AT = new Key("LookupCancelService.AUTO_POPUP_AT");
    }

    public static final /* synthetic */ Reminiscence access$getLastReminiscence$p(LookupCancelService $this) {
        return $this.lastReminiscence;
    }

    public static final /* synthetic */ void access$setLastReminiscence$p(LookupCancelService $this, Reminiscence reminiscence) {
        $this.lastReminiscence = reminiscence;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/LookupCancelService$Reminiscence;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "(Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "setEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "editorListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "dispose", "", "matches", "", "kotlin.idea"})
    public static final class Reminiscence {
        @Nullable
        private Editor editor;
        private RangeMarker marker;
        private CaretListener editorListener;

        @Nullable
        public final Editor getEditor() {
            return this.editor;
        }

        public final void setEditor(@Nullable Editor editor2) {
            this.editor = editor2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matches(@NotNull Editor editor2, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!Intrinsics.areEqual((Object)editor2, (Object)this.editor)) return false;
            RangeMarker rangeMarker = this.marker;
            if (rangeMarker == null) return false;
            if (rangeMarker.getStartOffset() != offset) return false;
            return true;
        }

        public final void dispose() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            application.assertIsDispatchThread();
            if (this.marker != null) {
                Editor editor2 = this.editor;
                Intrinsics.checkNotNull((Object)editor2);
                CaretModel caretModel = editor2.getCaretModel();
                CaretListener caretListener = this.editorListener;
                Intrinsics.checkNotNull((Object)caretListener);
                caretModel.removeCaretListener(caretListener);
                this.marker = null;
                this.editor = null;
                this.editorListener = null;
            }
        }

        public Reminiscence(@NotNull Editor editor2, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            this.marker = editor2.getDocument().createRangeMarker(offset, offset);
            this.editorListener = new CaretListener(this, offset, editor2){
                final /* synthetic */ Reminiscence this$0;
                final /* synthetic */ int $offset;
                final /* synthetic */ Editor $editor;

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Reminiscence.access$getMarker$p(this.this$0) != null) {
                        RangeMarker rangeMarker = Reminiscence.access$getMarker$p(this.this$0);
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        if (!rangeMarker.isValid() || this.$editor.logicalPositionToOffset(e.getNewPosition()) <= this.$offset) {
                            this.this$0.dispose();
                        }
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$offset = $captured_local_variable$1;
                    this.$editor = $captured_local_variable$2;
                }
            };
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            application.assertIsDispatchThread();
            CaretModel caretModel = editor2.getCaretModel();
            CaretListener caretListener = this.editorListener;
            Intrinsics.checkNotNull((Object)caretListener);
            caretModel.addCaretListener(caretListener);
        }

        public static final /* synthetic */ RangeMarker access$getMarker$p(Reminiscence $this) {
            return $this.marker;
        }

        public static final /* synthetic */ void access$setMarker$p(Reminiscence $this, RangeMarker rangeMarker) {
            $this.marker = rangeMarker;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/LookupCancelService$Companion;", "", "()V", "AUTO_POPUP_AT", "Lcom/intellij/openapi/util/Key;", "", "getAUTO_POPUP_AT", "()Lcom/intellij/openapi/util/Key;", "getInstance", "Lorg/jetbrains/kotlin/idea/completion/LookupCancelService;", "project", "Lcom/intellij/openapi/project/Project;", "getServiceIfCreated", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final LookupCancelService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(LookupCancelService.class);
            if (object == null) {
                String string = "Unable to locate service " + LookupCancelService.class.getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return (LookupCancelService)object;
        }

        @Nullable
        public final LookupCancelService getServiceIfCreated(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return (LookupCancelService)project2.getServiceIfCreated(LookupCancelService.class);
        }

        @NotNull
        public final Key<Integer> getAUTO_POPUP_AT() {
            return AUTO_POPUP_AT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

