/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelperKt;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

public abstract class KotlinTrySurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    protected boolean isApplicableWhenUsedAsExpression() {
        return false;
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement container2, @NotNull PsiElement[] statements) {
        if (project2 == null) {
            KotlinTrySurrounderBase.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            KotlinTrySurrounderBase.$$$reportNull$$$0(1);
        }
        if (container2 == null) {
            KotlinTrySurrounderBase.$$$reportNull$$$0(2);
        }
        if (statements == null) {
            KotlinTrySurrounderBase.$$$reportNull$$$0(3);
        }
        if ((statements = MoveDeclarationsOutHelperKt.move(container2, statements, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint((Project)project2, (Editor)editor2, (String)KotlinSurrounderUtils.SURROUND_WITH_ERROR());
            return null;
        }
        KtTryExpression tryExpression = (KtTryExpression)KtPsiFactoryKt.KtPsiFactory((Project)project2).createExpression(this.getCodeTemplate());
        tryExpression = (KtTryExpression)container2.addAfter((PsiElement)tryExpression, statements[statements.length - 1]);
        KtBlockExpression tryBlock2 = tryExpression.getTryBlock();
        KotlinSurrounderUtils.addStatementsInBlock((KtBlockExpression)tryBlock2, (PsiElement[])statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        tryExpression = (KtTryExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)tryExpression);
        return this.getTextRangeForCaret(tryExpression);
    }

    protected abstract String getCodeTemplate();

    @NotNull
    protected abstract TextRange getTextRangeForCaret(@NotNull KtTryExpression var1);

    public static TextRange getCatchTypeParameterTextRange(@NotNull KtTryExpression expression2) {
        if (expression2 == null) {
            KotlinTrySurrounderBase.$$$reportNull$$$0(4);
        }
        KtParameter parameter = ((KtCatchClause)expression2.getCatchClauses().get(0)).getCatchParameter();
        assert (parameter != null) : "Catch parameter should exists for " + expression2.getText();
        KtTypeReference typeReference = parameter.getTypeReference();
        assert (typeReference != null) : "Type reference for parameter should exists for " + expression2.getText();
        return typeReference.getTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCatchTypeParameterTextRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

