/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.refactoringTesting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.FileSystemChangesTracker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createdFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCreatedFiles", "()Ljava/util/Set;", "trackerListener", "org/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker$trackerListener$1", "Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker$trackerListener$1;", "dispose", "", "reset", "kotlin.idea"})
public final class FileSystemChangesTracker
implements Disposable {
    private final trackerListener.1 trackerListener;
    @NotNull
    private final Set<VirtualFile> createdFiles;

    public void dispose() {
        this.trackerListener.dispose();
    }

    public final void reset() {
        this.trackerListener.getCreatedFilesMutable().clear();
    }

    @NotNull
    public final Set<VirtualFile> getCreatedFiles() {
        return this.createdFiles;
    }

    public FileSystemChangesTracker(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.trackerListener = new VirtualFileListener(project2){
            @NotNull
            private final Set<VirtualFile> createdFilesMutable;
            private volatile boolean disposed;
            final /* synthetic */ Project $project;

            @NotNull
            public final Set<VirtualFile> getCreatedFilesMutable() {
                return this.createdFilesMutable;
            }

            public synchronized void dispose() {
                if (!this.disposed) {
                    this.disposed = true;
                    VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
                    this.createdFilesMutable.clear();
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.createdFilesMutable.add(virtualFile);
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.createdFilesMutable.add(virtualFile);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.createdFilesMutable.add(virtualFile);
            }
            {
                this.$project = $captured_local_variable$0;
                boolean bl = false;
                this.createdFilesMutable = new LinkedHashSet<E>();
                VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
                Disposer.register((Disposable)((Disposable)$captured_local_variable$0), (Disposable)this);
            }
        };
        this.createdFiles = this.trackerListener.getCreatedFilesMutable();
    }
}

