/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAwareReferencesSearchParameters;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "AliasProcessor", "kotlin.fir.frontend-independent"})
public final class KotlinAliasedImportedElementSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Object kotlinOptions;
        Object object;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ReferencesSearch.SearchParameters searchParameters = parameters;
        if (!(searchParameters instanceof KotlinAwareReferencesSearchParameters)) {
            searchParameters = null;
        }
        if ((object = (KotlinAwareReferencesSearchParameters)searchParameters) == null || (object = object.getKotlinOptions()) == null) {
            object = kotlinOptions = KotlinReferencesSearchOptions.Companion.getEmpty();
        }
        if (!((KotlinReferencesSearchOptions)kotlinOptions).getAcceptImportAlias()) {
            return;
        }
        PsiElement psiElement = parameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.elementToSearch");
        PsiElement element2 = psiElement;
        if (!element2.isValid()) {
            return;
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element2);
        if (psiNamedElement == null) {
            return;
        }
        PsiNamedElement unwrappedElement = psiNamedElement;
        String name = unwrappedElement.getName();
        if (name == null || StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        SearchScope effectiveSearchScope = KotlinReferencesSearchOptions.Companion.calculateEffectiveScope$kotlin_fir_frontend_independent(unwrappedElement, parameters);
        SearchRequestCollector searchRequestCollector = parameters.getOptimizer();
        Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"parameters.optimizer");
        SearchRequestCollector collector = searchRequestCollector;
        SearchSession searchSession = collector.getSearchSession();
        Intrinsics.checkNotNullExpressionValue((Object)searchSession, (String)"collector.searchSession");
        SearchSession session = searchSession;
        collector.searchWord(name, effectiveSearchScope, (short)1, true, element2, (RequestResultProcessor)new AliasProcessor(element2, session));
    }

    public KotlinAliasedImportedElementSearcher() {
        super(true);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher$AliasProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "myTarget", "Lcom/intellij/psi/PsiElement;", "mySession", "Lcom/intellij/psi/search/SearchSession;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchSession;)V", "processTextOccurrence", "", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "kotlin.fir.frontend-independent"})
    private static final class AliasProcessor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        private final SearchSession mySession;

        public boolean processTextOccurrence(@NotNull PsiElement element2, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            PsiElement psiElement = element2.getParent();
            if (!(psiElement instanceof KtImportDirective)) {
                psiElement = null;
            }
            KtImportDirective ktImportDirective = (KtImportDirective)psiElement;
            if (ktImportDirective == null) {
                return true;
            }
            KtImportDirective importStatement = ktImportDirective;
            Object object = importStatement.getAlias();
            if (object == null || (object = object.getName()) == null) {
                return true;
            }
            Object importAlias = object;
            Object object2 = importStatement.getImportedReference();
            if (object2 == null || (object2 = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)object2))) == null || (object2 = ReferenceUtilsKt.getMainReference((KtElement)object2)) == null) {
                return true;
            }
            Object reference = object2;
            if (!reference.isReferenceTo(this.myTarget)) {
                return true;
            }
            SearchRequestCollector collector = new SearchRequestCollector(this.mySession);
            SearchScope fileScope = (SearchScope)new LocalSearchScope((PsiElement)element2.getContainingFile());
            collector.searchWord((String)importAlias, fileScope, (short)1, true, this.myTarget);
            return PsiSearchHelper.getInstance((Project)element2.getProject()).processRequests(collector, consumer);
        }

        public AliasProcessor(@NotNull PsiElement myTarget, @NotNull SearchSession mySession) {
            Intrinsics.checkNotNullParameter((Object)myTarget, (String)"myTarget");
            Intrinsics.checkNotNullParameter((Object)mySession, (String)"mySession");
            super(new Object[]{myTarget});
            this.myTarget = myTarget;
            this.mySession = mySession;
        }
    }
}

