/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinBundleIndependent;
import org.jetbrains.kotlin.idea.asJava.LightClassProvider;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesSupport;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.handlers.DelegatingFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinTypeParameterFindUsagesHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001aH\u0016J\u001e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/KotlinFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "getDefaultOptions", "()Lcom/intellij/find/findUsages/FindUsagesOptions;", "findClassOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "getFindClassOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "findFunctionOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "getFindFunctionOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "findPropertyOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "getFindPropertyOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "javaHandlerFactory", "Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "getJavaHandlerFactory", "()Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "askWhetherShouldSearchForParameterInOverridingMethods", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "canFindUsages", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "handlerForMultiple", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declarations", "", "kotlin.fir.frontend-independent"})
public final class KotlinFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @NotNull
    private final JavaFindUsagesHandlerFactory javaHandlerFactory;
    @NotNull
    private final KotlinFunctionFindUsagesOptions findFunctionOptions;
    @NotNull
    private final KotlinPropertyFindUsagesOptions findPropertyOptions;
    @NotNull
    private final KotlinClassFindUsagesOptions findClassOptions;
    @NotNull
    private final FindUsagesOptions defaultOptions;

    @NotNull
    public final JavaFindUsagesHandlerFactory getJavaHandlerFactory() {
        return this.javaHandlerFactory;
    }

    @NotNull
    public final KotlinFunctionFindUsagesOptions getFindFunctionOptions() {
        return this.findFunctionOptions;
    }

    @NotNull
    public final KotlinPropertyFindUsagesOptions getFindPropertyOptions() {
        return this.findPropertyOptions;
    }

    @NotNull
    public final KotlinClassFindUsagesOptions getFindClassOptions() {
        return this.findClassOptions;
    }

    @NotNull
    public final FindUsagesOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canFindUsages(@NotNull PsiElement element2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof KtClassOrObject || element2 instanceof KtNamedFunction || element2 instanceof KtProperty || element2 instanceof KtParameter || element2 instanceof KtTypeParameter || element2 instanceof KtConstructor || element2 instanceof KtImportAlias && ((object = ((KtImportAlias)element2).getImportDirective()) != null && (object = object.getImportedReference()) != null && (object = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)object))) != null && (object = ReferenceUtilsKt.getMainReference((KtElement)object)) != null ? object.resolve() : null) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        if (psiElement instanceof KtImportAlias) {
            FindUsagesHandler findUsagesHandler;
            PsiElement resolvedElement;
            Object object = ((KtImportAlias)element2).getImportDirective();
            PsiElement psiElement2 = object != null && (object = object.getImportedReference()) != null && (object = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)object))) != null && (object = ReferenceUtilsKt.getMainReference((KtElement)object)) != null ? object.resolve() : (resolvedElement = null);
            if (resolvedElement instanceof KtClassOrObject) {
                if (!forHighlightUsages) {
                    findUsagesHandler = this.createFindUsagesHandler(resolvedElement, forHighlightUsages);
                } else {
                    FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                    findUsagesHandler = findUsagesHandler2;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                }
            } else if (resolvedElement instanceof KtNamedFunction || resolvedElement instanceof KtProperty || resolvedElement instanceof KtConstructor) {
                findUsagesHandler = this.createFindUsagesHandler(resolvedElement, forHighlightUsages);
            } else {
                FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler3;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"NULL_HANDLER");
            }
            return findUsagesHandler;
        }
        if (psiElement instanceof KtClassOrObject) {
            return new KotlinFindClassUsagesHandler((KtClassOrObject)element2, this);
        }
        if (psiElement instanceof KtParameter) {
            if (!forHighlightUsages) {
                PsiMethod psiMethod;
                if (((KtParameter)element2).hasValOrVar()) {
                    List<PsiElement> declarationsToSearch = KotlinFindUsagesSupport.Companion.checkSuperMethods((KtDeclaration)element2, null, KotlinBundleIndependent.message("find.usages.action.text.find.usages.of", new Object[0]));
                    return this.handlerForMultiple((KtNamedDeclaration)element2, (Collection<? extends PsiElement>)declarationsToSearch);
                }
                KtDeclarationWithBody function = ((KtParameter)element2).getOwnerFunction();
                if (function != null && KotlinSearchUsagesSupport.Companion.isOverridable((KtDeclaration)function) && (psiMethod = (PsiMethod)CollectionsKt.singleOrNull(LightClassProvider.Companion.providedToLightMethods((PsiElement)function))) != null) {
                    Query query = OverridingMethodsSearch.search((PsiMethod)psiMethod);
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"OverridingMethodsSearch.search(psiMethod)");
                    boolean hasOverridden = CollectionsKt.any((Iterable)((Iterable)query));
                    if (hasOverridden && this.askWhetherShouldSearchForParameterInOverridingMethods((KtParameter)element2)) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$filterTo$iv$iv;
                        PsiParameterList psiParameterList = psiMethod.getParameterList();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"psiMethod.parameterList");
                        int parametersCount = psiParameterList.getParametersCount();
                        int parameterIndex = KtPsiUtilKt.parameterIndex((PsiElement)element2);
                        boolean bl = parameterIndex < parametersCount;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        Query query2 = OverridingMethodsSearch.search((PsiMethod)psiMethod, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"OverridingMethodsSearch.search(psiMethod, true)");
                        Iterable $this$filter$iv = (Iterable)query2;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            PsiMethod it = (PsiMethod)element$iv$iv;
                            boolean bl5 = false;
                            PsiMethod psiMethod2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"it");
                            PsiParameterList psiParameterList2 = psiMethod2.getParameterList();
                            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"it.parameterList");
                            if (!(psiParameterList2.getParametersCount() == parametersCount)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$mapNotNull = false;
                        $this$filterTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            PsiElement psiElement3;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl6 = false;
                            PsiMethod it = (PsiMethod)element$iv$iv;
                            boolean bl7 = false;
                            PsiMethod psiMethod3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiMethod3, (String)"it");
                            PsiParameterList psiParameterList3 = psiMethod3.getParameterList();
                            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList3, (String)"it.parameterList");
                            PsiParameter psiParameter = psiParameterList3.getParameters()[parameterIndex];
                            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"it.parameterList.parameters[parameterIndex]");
                            if (LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)psiParameter)) == null) continue;
                            boolean bl8 = false;
                            boolean bl9 = false;
                            PsiElement it$iv$iv = psiElement3;
                            boolean bl10 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List overridingParameters = (List)destination$iv$iv;
                        return this.handlerForMultiple((KtNamedDeclaration)element2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)element2), (Iterable)overridingParameters));
                    }
                }
            }
            return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)element2, null, this, 2, null);
        }
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty || psiElement instanceof KtConstructor) {
            KtNamedDeclaration declaration = (KtNamedDeclaration)element2;
            if (forHighlightUsages) {
                return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, declaration, null, this, 2, null);
            }
            List<PsiElement> declarationsToSearch = KotlinFindUsagesSupport.Companion.checkSuperMethods((KtDeclaration)declaration, null, KotlinBundleIndependent.message("find.usages.action.text.find.usages.of", new Object[0]));
            return this.handlerForMultiple(declaration, (Collection<? extends PsiElement>)declarationsToSearch);
        }
        if (psiElement instanceof KtTypeParameter) {
            return new KotlinTypeParameterFindUsagesHandler((KtNamedDeclaration)element2, this);
        }
        throw (Throwable)new IllegalArgumentException("unexpected element type: " + element2);
    }

    private final FindUsagesHandler handlerForMultiple(KtNamedDeclaration originalDeclaration, Collection<? extends PsiElement> declarations) {
        FindUsagesHandler findUsagesHandler;
        switch (declarations.size()) {
            case 0: {
                FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler2;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                break;
            }
            case 1: {
                FindUsagesHandler findUsagesHandler3;
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)CollectionsKt.single((Iterable)declarations)));
                if (psiElement == null) {
                    FindUsagesHandler findUsagesHandler4 = FindUsagesHandler.NULL_HANDLER;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler4, (String)"NULL_HANDLER");
                    return findUsagesHandler4;
                }
                PsiElement target = psiElement;
                if (target instanceof KtNamedDeclaration) {
                    findUsagesHandler3 = KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)target, null, this, 2, null);
                } else {
                    FindUsagesHandler findUsagesHandler5 = this.javaHandlerFactory.createFindUsagesHandler(target, false);
                    findUsagesHandler3 = findUsagesHandler5;
                    Intrinsics.checkNotNull((Object)findUsagesHandler5);
                }
                findUsagesHandler = findUsagesHandler3;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"if (target is KtNamedDec\u2026alse)!!\n                }");
                break;
            }
            default: {
                findUsagesHandler = new DelegatingFindMemberUsagesHandler(originalDeclaration, declarations, this);
            }
        }
        return findUsagesHandler;
    }

    private final boolean askWhetherShouldSearchForParameterInOverridingMethods(KtParameter parameter) {
        return Messages.showOkCancelDialog((Project)parameter.getProject(), (String)JavaBundle.message((String)"find.parameter.usages.in.overriding.methods.prompt", (Object[])new Object[]{parameter.getName()}), (String)JavaBundle.message((String)"find.parameter.usages.in.overriding.methods.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public KotlinFindUsagesHandlerFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.javaHandlerFactory = new JavaFindUsagesHandlerFactory(project);
        this.findFunctionOptions = new KotlinFunctionFindUsagesOptions(project);
        this.findPropertyOptions = new KotlinPropertyFindUsagesOptions(project);
        this.findClassOptions = new KotlinClassFindUsagesOptions(project);
        this.defaultOptions = new FindUsagesOptions(project);
    }
}

