/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorageBase;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.CachingJpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReaderWithCache;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImplKt;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/configurationStore/StorageJpsConfigurationReader;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReaderWithCache;", "project", "Lcom/intellij/openapi/project/Project;", "baseDirUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "fileContentCachingReader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CachingJpsFileContentReader;", "clearCache", "", "getCachingReader", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "fileUrl", "loadComponent", "Lorg/jdom/Element;", "componentName", "customModuleFilePath", "intellij.platform.configurationStore.impl"})
public final class StorageJpsConfigurationReader
implements JpsFileContentReaderWithCache {
    private volatile CachingJpsFileContentReader fileContentCachingReader;
    private final Project project;
    private final String baseDirUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Object object;
        String filePath;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
                Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
                filePath = JpsPathUtil.urlToPath((String)fileUrl);
                if (Intrinsics.areEqual((Object)componentName, (Object)"")) {
                    Element element;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
                    Object object2 = file;
                    if (object2 != null && (object2 = object2.getInputStream()) != null) {
                        Closeable closeable = (Closeable)object2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl3 = false;
                            Element element2 = JDOMUtil.load((InputStream)it);
                            element = element2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    } else {
                        element = null;
                    }
                    return element;
                }
                if (FileUtil.extensionEquals((String)filePath, (String)"iml")) break block14;
                String string = filePath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
                if (!JpsProjectSerializersImplKt.isExternalModuleFile((String)string)) break block15;
            }
            return this.getCachingReader().loadComponent(fileUrl, componentName, customModuleFilePath);
        }
        StateStorageBase<StateMap> stateStorageBase = ProjectStoreBridgeKt.getProjectStateStorage(filePath, ProjectKt.getStateStore((Project)this.project), this.project);
        if (stateStorageBase == null) {
            return null;
        }
        StateStorageBase<StateMap> storage2 = stateStorageBase;
        StateMap stateMap = (StateMap)storage2.getStorageData();
        if (storage2 instanceof DirectoryBasedStorageBase) {
            String string = PathUtil.getFileName((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(filePath)");
            Element elementContent = StateMap.getElement$default(stateMap, string, null, 2, null);
            object = elementContent != null ? new Element("component").setAttribute("name", componentName).addContent(elementContent) : null;
        } else {
            object = StateMap.getElement$default(stateMap, componentName, null, 2, null);
        }
        return object;
    }

    private final CachingJpsFileContentReader getCachingReader() {
        CachingJpsFileContentReader reader;
        CachingJpsFileContentReader cachingJpsFileContentReader = this.fileContentCachingReader;
        if (cachingJpsFileContentReader == null) {
            cachingJpsFileContentReader = reader = new CachingJpsFileContentReader(this.baseDirUrl);
        }
        if (this.fileContentCachingReader == null) {
            this.fileContentCachingReader = reader;
        }
        return reader;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
                String filePath = JpsPathUtil.urlToPath((String)fileUrl);
                if (FileUtil.extensionEquals((String)filePath, (String)"iml")) break block2;
                String string = filePath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath");
                if (!JpsProjectSerializersImplKt.isExternalModuleFile((String)string)) break block3;
            }
            return this.getCachingReader().getExpandMacroMap(fileUrl);
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
        ExpandMacroToPathMap expandMacroToPathMap = pathMacroManager.getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"PathMacroManager.getInst\u2026e(project).expandMacroMap");
        return expandMacroToPathMap;
    }

    public void clearCache() {
        this.fileContentCachingReader = null;
    }

    public StorageJpsConfigurationReader(@NotNull Project project, @NotNull String baseDirUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDirUrl, (String)"baseDirUrl");
        this.project = project;
        this.baseDirUrl = baseDirUrl;
    }
}

