/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.PortMapper;
import net.i2p.util.VersionComparator;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyStart
implements ClientApp {
    private final ClientAppManager _mgr;
    private final String[] _args;
    private final List<LifeCycle> _jettys;
    private final I2PAppContext _context;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private volatile int _port;
    private volatile int _sslPort;
    private static final String GZIP_DIR = "eepsite-jetty9.3";
    private static final String GZIP_CONFIG = "jetty-gzip.xml";
    private static final String MIN_GZIP_HANDLER_VER = "9.3";

    public JettyStart(I2PAppContext context, ClientAppManager mgr, String[] args) throws Exception {
        this._mgr = mgr;
        this._args = args;
        this._jettys = new ArrayList<LifeCycle>(args.length);
        this._context = context;
        this.parseArgs(args);
        this._state = ClientAppState.INITIALIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseArgs(String[] args) throws Exception {
        int i;
        if (VersionComparator.comp((String)Server.getVersion(), (String)MIN_GZIP_HANDLER_VER) >= 0) {
            boolean found = false;
            File path = new File(".");
            for (i = 0; i < args.length; ++i) {
                if (args[i].toLowerCase().endsWith(".properties")) continue;
                if (args[i].toLowerCase().endsWith(GZIP_CONFIG)) {
                    found = true;
                    break;
                }
                File f = new File(args[i]);
                File p = f.getParentFile();
                if (p == null) continue;
                path = p;
            }
            if (!found) {
                File f = new File(path, GZIP_CONFIG);
                boolean exists = f.exists();
                if (!exists && !this._context.getBaseDir().equals(this._context.getConfigDir())) {
                    File from = new File(this._context.getBaseDir(), GZIP_DIR);
                    from = new File(from, GZIP_CONFIG);
                    exists = FileUtil.copy((File)from, (File)f, (boolean)false, (boolean)true);
                }
                if (exists) {
                    String[] nargs = new String[args.length + 1];
                    System.arraycopy(args, 0, nargs, 0, args.length);
                    nargs[args.length] = f.getPath();
                    args = nargs;
                }
            }
        }
        Properties properties = new Properties();
        XmlConfiguration last = null;
        for (i = 0; i < args.length; ++i) {
            Object o;
            File f = new File(args[i]);
            if (args[i].toLowerCase().endsWith(".properties")) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    properties.load(in);
                    continue;
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            URL configUrl = f.toURI().toURL();
            XmlConfiguration configuration = new XmlConfiguration(configUrl);
            if (last != null) {
                configuration.getIdMap().putAll(last.getIdMap());
            }
            if (properties.size() > 0) {
                Map<String, String> foo = configuration.getProperties();
                foo.putAll(properties);
            }
            if ((o = configuration.configure()) instanceof LifeCycle) {
                this._jettys.add((LifeCycle)o);
            }
            last = configuration;
        }
    }

    public synchronized void startup() {
        if (this._state != ClientAppState.INITIALIZED && this._state != ClientAppState.STOPPED && this._state != ClientAppState.START_FAILED) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.START_FAILED);
        } else {
            new Starter().start();
        }
    }

    public synchronized void shutdown(String[] args) {
        if (this._state != ClientAppState.RUNNING) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.STOPPED);
        } else {
            new Stopper().start();
        }
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return "Jetty";
    }

    public String getDisplayName() {
        return "Jetty " + Arrays.toString(this._args);
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, null, e);
        }
    }

    public static void main(String[] args) {
        try {
            JettyStart js = new JettyStart(null, null, args);
            js.startup();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Stopper
    extends I2PAppThread {
        public Stopper() {
            super("JettyStopper");
            JettyStart.this.changeState(ClientAppState.STOPPING);
        }

        public void run() {
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (!lc.isRunning()) continue;
                try {
                    lc.stop();
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.STOPPING, e);
                }
            }
            if (JettyStart.this._context != null) {
                PortMapper pm = JettyStart.this._context.portMapper();
                if (JettyStart.this._port > 0) {
                    pm.unregister("eepsite", JettyStart.this._port);
                    JettyStart.this._port = 0;
                }
                if (JettyStart.this._sslPort > 0) {
                    pm.unregister("https_eepsite", JettyStart.this._sslPort);
                    JettyStart.this._sslPort = 0;
                }
            }
            JettyStart.this.changeState(ClientAppState.STOPPED);
        }
    }

    private class Starter
    extends I2PAppThread {
        public Starter() {
            super("JettyStarter");
            JettyStart.this.changeState(ClientAppState.STARTING);
        }

        public void run() {
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (lc.isRunning()) continue;
                try {
                    lc.start();
                    if (JettyStart.this._context == null) continue;
                    PortMapper pm = JettyStart.this._context.portMapper();
                    if (!(lc instanceof Server)) continue;
                    Server server = (Server)lc;
                    Connector[] connectors = server.getConnectors();
                    for (int i = 0; i < connectors.length; ++i) {
                        String svc;
                        AbstractNetworkConnector nconn;
                        int port;
                        Connector conn = connectors[i];
                        if (!(conn instanceof AbstractNetworkConnector) || (port = (nconn = (AbstractNetworkConnector)conn).getPort()) <= 0) continue;
                        String host = nconn.getHost();
                        if (host.equals("0.0.0.0")) {
                            host = "127.0.0.1";
                        } else if (host.equals("::")) {
                            host = "::1";
                        }
                        boolean isSSL = false;
                        for (ConnectionFactory fact : nconn.getConnectionFactories()) {
                            if (!fact.getProtocol().startsWith("SSL")) continue;
                            isSSL = true;
                            break;
                        }
                        if (isSSL) {
                            JettyStart.this._sslPort = port;
                            svc = "https_eepsite";
                        } else {
                            JettyStart.this._port = port;
                            svc = "eepsite";
                        }
                        pm.register(svc, host, port);
                    }
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.START_FAILED, e);
                    return;
                }
            }
            JettyStart.this.changeState(ClientAppState.RUNNING);
            if (JettyStart.this._mgr != null) {
                JettyStart.this._mgr.register((ClientApp)JettyStart.this);
            }
        }
    }
}

